/*
 * $Id: NewElementWizardPage.java,v 1.2 2004/04/14 02:58:48 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;


/**
 * 
 */
public class NewElementWizardPage extends EditElementWizardPage {

	Text elementName;
	EditElementWizardPage nextPage = null;

	public NewElementWizardPage() {
		super("NewElementPage");
		setTitle("Create HTML Element");
		setDescription("Sepcify new insert element name and that element configuration.");
	}
	
	protected void createChildControl(Composite base) {
		// create foundation component
		base.setLayout(new GridLayout(1, false));
		
		// element input components
		new Label(base, SWT.NONE).setText("&Element Name:");
		
		elementName = new Text(base, SWT.BORDER | SWT.SINGLE);
		elementName.setLayoutData( new GridData(GridData.FILL_HORIZONTAL));
		elementName.addModifyListener( new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				String eName = elementName.getText();
				if( eName.indexOf(' ') != -1 ){
					setErrorMessage("Don't contain blink in speicfied element name.");
				} else if (eName.length() == 0){
					setErrorMessage("Need to specify element name.");
				} else {
					setErrorMessage(null);
					nextPage = ((EditElementWizard)getWizard()).createElementEditPage(eName);
					nextPage.setElementName(eName);
					if( nextPage instanceof UnknownElementWizardPage){
						setMessage("This editor does not known element name.", WARNING);
					}else{
						setMessage(null, NONE);
					}
				}
				refreshPreview();
				getWizard().getContainer().updateButtons();
			}
		});
	}
	
	public String getPreviewText(){
		if(nextPage instanceof EditElementWizardPage){
			return ((EditElementWizardPage)nextPage).getPreviewText();
		}
		return null;
	}
	
	public void setErrorMessage(String newMessage) {
		super.setErrorMessage(newMessage);
		if( newMessage != null){
			nextPage = null;
		}
	}

	public IWizardPage getNextPage() {
		return nextPage;
	}

}
