/*
 * $Id: FormElementWizardPage.java,v 1.1 2004/04/11 08:23:40 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.*;

/**
 * 
 */
public class FormElementWizardPage extends EditElementWizardPage {

	Text actionText;
	Button postRadio, getRadio, multipartCheck;
	Combo charsetCombo;

	public FormElementWizardPage() {
		super("FormElementWizardPage");
	}

	protected void createChildControl(Composite parent) throws CoreException {
		postRadio = new Button(parent, SWT.RADIO);
		
	}

	public String getPreviewText() {
		boolean controlCreated = actionText != null;
		
		StringBuffer buff = new StringBuffer("<form action=\"");
		if(controlCreated){
			buff.append(actionText.getText());
		}
		buff.append("\" method=\"");
		if( controlCreated && postRadio.getSelection() ){
			buff.append("POST\"");
			if(multipartCheck.getSelection()){
				buff.append(" enctype=\"multipart/form-data\"");
			}
			
		}else{
			buff.append("GET\"");
		}
		
		if(controlCreated){
			String charset = charsetCombo.getText();
			if(charset != null){
				buff.append(" accept-charset=\"" + charset + "\"");
			}
		}
		
		buff.append(">\n");
		buff.append( getSelectionText() );
		buff.append("\n</form>\n");
		
		return buff.toString();
	}

}
