/*
 * $Id: HTOutlineContentProvider.java,v 1.3 2004/04/24 05:04:46 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import org.eclipse.jface.text.*;
import org.eclipse.jface.viewers.*;

import com.narucy.webpub.core.template.*;
import com.narucy.webpub.ui.DocLineIterator;

/**
 * 
 */
public class HTOutlineContentProvider implements ITreeContentProvider {

	final public static String PROP_LENGTH_LINE = "length_line";
	
	TemplateParser parser = new TemplateParser();

	TreeViewer viewer;
	
	Template rootTemplate;
	TemplateParseException error;

	IDocumentListener docListener = new IDocumentListener(){
		public void documentAboutToBeChanged(DocumentEvent ev) {}

		public void documentChanged(DocumentEvent ev) {
			refreshAsDocument(ev.fDocument);
		}
	};

	/**
	 * Return null not provides error as input document.
	 */
	public TemplateParseException getError() {
		return error;
	}
	
	/**
	 * returns current input document parsed template.
	 * return null if parse failed.
	 */
	public Template getTemporaryTemplate() {
		return rootTemplate;
	}
	
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		this.viewer = (TreeViewer)viewer;
		if (oldInput != null) {
			((IDocument)oldInput).removeDocumentListener(docListener);
		}
		if (newInput != null) {
			IDocument newInputdoc = (IDocument)newInput;
			refreshAsDocument(newInputdoc);
			newInputdoc.addDocumentListener(docListener);
		}
	}

	void refreshAsDocument(IDocument doc){
		try {
			Template newTmpl = parser.parse(new DocLineIterator(doc), "Root");
			error = null;
			if(rootTemplate == null || !compareTemplateStructure(rootTemplate, newTmpl)){
				rootTemplate = newTmpl;
				refreshAndExpand();
			}
		} catch (TemplateParseException e) {
			rootTemplate = null;
			if(!e.equals(error)){
				error = e;
				refreshAndExpand();
			}
		}
	}
	
	boolean compareTemplateStructure( Template baseTmpl, Template newTmpl){
		if(baseTmpl == null || !baseTmpl.getName().equals(newTmpl.getName())){
			return false;
		}
		Template[] baseChildren = baseTmpl.getChildrenTemplates();
		Template[] newChildren = newTmpl.getChildrenTemplates();
		if(baseChildren.length != newChildren.length){
			return false;
		}
		for (int i = 0; i < newChildren.length; i++) {
			if(!compareTemplateStructure(baseChildren[i], newChildren[i])){
				return false;
			}
		}
		// update line number infomation for HTOutlinePage refresh as curosr position.
		baseTmpl.setProperty(TemplateParser.PROP_OFFSET_LINE, newTmpl.getProperty(TemplateParser.PROP_OFFSET_LINE));
		baseTmpl.setProperty(PROP_LENGTH_LINE, new Integer(newTmpl.getLines().length) );
		
		return true;
	}
	
	void refreshAndExpand(){
		viewer.refresh();
		viewer.expandAll();
	}
	
	public Object getParent(Object element) {
		if(element instanceof Template){
			return ((Template)element).getProperty(TemplateParser.PROP_PARENT);
		}
		return null;
	}

	public boolean hasChildren(Object element) {
		if(element instanceof Template){
			Template tmpl = (Template)element;
			return (tmpl.getChildrenTemplates().length > 0 || tmpl.getInvalidTemplateNames().length > 0);
		}
		return false;
	}
	
	public Object[] getChildren(Object parentElement) {
		if(parentElement instanceof Template){
			Template tmpl = (Template)parentElement;
			return tmpl.getChildrenTemplates();
		}
		return null;
	}

	public Object[] getElements(Object inputElem) {
		if(rootTemplate != null){
			return new Object[]{ rootTemplate };
		}
		if(error != null){
			return new Object[]{ error };
		}
		return new Object[0];
	}
	
	public void dispose() {
	}

}
