/*
 * $Id: CSSLink.java,v 1.2 2004/04/17 22:56:19 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import java.util.regex.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.text.*;
import org.eclipse.ui.*;
import org.eclipse.ui.texteditor.ITextEditor;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * CSSLink
 */
class CSSLink implements IRelativeResourceLinkChooser {

	static Pattern cssLinkPattern =
		Pattern.compile("^<link\\s+.*rel=\"stylesheet\".*.*href=\"(.+\\.css)\".*\\s*");

	public IFile chooseLink(ITextEditor editor) throws CoreException {
		IEditorInput input = editor.getEditorInput();
		if( input instanceof IFileEditorInput ){
			IDocument doc =
				editor.getDocumentProvider().getDocument( editor.getEditorInput() );
			
			try{
				for(int i=0; i<doc.getNumberOfLines(); i++){
					String line = doc.get(doc.getLineOffset(i), doc.getLineLength(i));

					Matcher match = cssLinkPattern.matcher(line);
					if( match.matches() ){
						String path = match.group(1);
						IFile htFile = ((IFileEditorInput)input).getFile();
					
						IFile cssFile;
						if( path.charAt(0) == '/'){
							path = path.substring(1);
							IProject proj = htFile.getProject();
							WebProject wp = (WebProject)proj.getNature(WebProject.ID_NATURE);
							cssFile = (wp != null) ?
								wp.getFolder(WebProject.KEY_HTSOURCES_FOLDER).getFile(new Path(path)) :
								proj.getFile(path);
						}else{
							cssFile = htFile.getParent().getFile(new Path(path));
						}
						return cssFile;
					}
				}
			}catch(BadLocationException ex){
				WebpubUIPlugin.handleException(ex);
			}
		}
		return null;
	}

}
