/*
 * $Id: InsertTemplateAction.java,v 1.1 2004/04/11 08:23:45 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.ui.*;
import org.eclipse.ui.texteditor.ITextEditor;

import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.editors.html.wizards.InsertTemplateWizard;

/**
 * TemplateAddAction
 */
public class InsertTemplateAction implements IEditorActionDelegate {

	ITextEditor editor = null;

	public InsertTemplateAction(){
	}

	public void run(IAction action) {
		if( editor != null){
			try{
				WizardDialog wizDialog =
					new WizardDialog(
						editor.getSite().getShell(),
						new InsertTemplateWizard(editor) ){
					
					protected int getShellStyle() {
						return super.getShellStyle() | SWT.RESIZE;
					}
				};
				wizDialog.open();
			}catch(CoreException e){
				WebpubUIPlugin.handleException(e);
			}
		}
	}

	public void setActiveEditor(IAction action, IEditorPart ed) {
		if( ed instanceof ITextEditor){
			editor = (ITextEditor)ed;
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}

}
