/*
 * $Id: InsertNewElementAction.java,v 1.1 2004/04/11 08:23:45 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.ui.*;
import org.eclipse.ui.texteditor.ITextEditor;

import com.narucy.webpub.ui.editors.html.wizards.EditElementWizard;

/**
 * InsertTagAction
 */
public class InsertNewElementAction implements IEditorActionDelegate {

	ITextEditor targetEditor = null;

	public InsertNewElementAction() {
	}
	
	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
		if(targetEditor instanceof ITextEditor){
			this.targetEditor = (ITextEditor)targetEditor;
		}
	}

	public void run(IAction action) {
	
		WizardDialog wizDialog =
			new WizardDialog(
				targetEditor.getSite().getShell(),
				new EditElementWizard(targetEditor, null) ){

			protected int getShellStyle() {
				return super.getShellStyle() | SWT.RESIZE;
			}
		};
		
		wizDialog.open();
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}

}
