/*
 * $Id: WebpubUIPlugin.java,v 1.8 2004/04/27 00:03:46 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.*;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import com.narucy.webpub.core.WebpubPlugin;

/**
 * The main plugin class.
 */
public class WebpubUIPlugin extends AbstractUIPlugin {

	final public static String
		// name
		ID_PLUGIN = "com.narucy.webpub",
		// preference keys
		HT_PREVIEW_EXTENSIONS = "ht_preview_extensions",
		HT_EDITOR_DISPLAYED_TAB_WIDTH = "ht_editor_displayed_tab_editor",
		HT_EDITOR_WORDWRAP = "ht_editor_wordwrap",
		HT_EDITOR_COLOR_BACKGROUND = "ht_editor_color_background",
		HT_EDITOR_COLOR_DEFAULT = "ht_editor_color_default",
		HT_EDITOR_COLOR_TAG = "ht_editor_color_tag",
		HT_EDITOR_COLOR_ATTR = "ht_editor_color_attr",
		HT_EDITOR_COLOR_COMMENT = "ht_editor_color_comment",
		HT_EDITOR_COLOR_ERB = "ht_editor_color_erb",
		HT_EDITOR_COLOR_PROCESSOR = "ht_editor_color_processor",
		HT_EDITOR_CONTENT_ASSIST = "ht_editor_content_assist",
		HT_EDITOR_CONTENT_ASSIST_DELAY = "ht_editor_content_assist_delay",
		PUBLISH_BACKGROUND = "publish_background",
		RUBY_INTERPRETER_LOCATION = "ruby_interpreter_location";

	static WebpubUIPlugin plugin;
	static ResourceBundle resourceBundle;

	public WebpubUIPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
		try {
			resourceBundle= ResourceBundle.getBundle("webpubui");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}
	
	public static ResourceBundle getResourceBundle(){
		return resourceBundle;
	}

	public static WebpubUIPlugin getDefault() {
		return plugin;
	}
	
	public static void handleException(Exception e){
		plugin.getLog().log(
				(e instanceof CoreException) ?
					((CoreException)e).getStatus() :
					new Status(IStatus.ERROR, ID_PLUGIN, IStatus.OK, e.getMessage() == null ? "error" : e.getMessage(), e) );
	}

	/**
	 * Initializes a preference store with default preference values 
	 * for this plug-in.
	 * 
	 * @param store the preference store to fill
	 */
	protected void initializeDefaultPreferences(IPreferenceStore store) {
		IPath rubyPath = WebpubPlugin.findInitialInterpreter();
		store.setDefault(
			RUBY_INTERPRETER_LOCATION, rubyPath != null ?
				rubyPath.toString() :
				"c:/ruby/bin/ruby.exe");
		
		// initialize preview preference
		store.setDefault( HT_PREVIEW_EXTENSIONS,
			"html htm erb xml jpeg jpg gif png rd");

		store.setDefault(PUBLISH_BACKGROUND, true);
		
		// initialize html editor preference
		store.setDefault(HT_EDITOR_DISPLAYED_TAB_WIDTH, 4);
		store.setDefault(HT_EDITOR_WORDWRAP, false);
		
		store.setDefault(HT_EDITOR_COLOR_BACKGROUND, "255,255,255");
		store.setDefault(HT_EDITOR_COLOR_DEFAULT, "0,0,0");
		store.setDefault(HT_EDITOR_COLOR_TAG, "0,0,127");
		store.setDefault(HT_EDITOR_COLOR_COMMENT, "0,127,0");
		store.setDefault(HT_EDITOR_COLOR_ERB, "127,127,127");
		store.setDefault(HT_EDITOR_COLOR_ATTR, "127,0,0");
		store.setDefault(HT_EDITOR_COLOR_PROCESSOR, "127,0,127");

		store.setDefault(HT_EDITOR_CONTENT_ASSIST, true);
		store.setDefault(HT_EDITOR_CONTENT_ASSIST_DELAY, 500);
		
		refreshInterpreterLocation();
	}

	void refreshInterpreterLocation(){
		IPreferenceStore store = getPreferenceStore();
		String location = store.getString(RUBY_INTERPRETER_LOCATION);
		if( location != null && location.length() > 0){
			WebpubPlugin.getDefault().setRubyCommandPath(new Path(location));
		}
	}
	
	public static String join(String[] vals){
		StringBuffer buff = new StringBuffer();
		for (int i = 0; i < vals.length; i++) {
			buff.append(vals[i]);
			if(i != vals.length-1){
				buff.append(' ');
			}
		}
		return buff.toString();
	}
	
	public static ImageDescriptor getImageDescriptor(String iconPath){
		URL imgUrl = plugin.find(new Path("icons/" + iconPath));
		if(imgUrl == null){
			throw new IllegalArgumentException(iconPath);
		}
		return ImageDescriptor.createFromURL(imgUrl);
	}
	
	public static Image createImage(String iconPath){
		return getImageDescriptor(iconPath).createImage();
	}
	
	public static IWorkbenchWindow getActiveWorkbenchWindow(){
		return plugin.getWorkbench().getActiveWorkbenchWindow();
	}
	
	public static IWorkbenchPage getActivePage(){
		return getActiveWorkbenchWindow().getActivePage();
	}

	public String getRDTSelectedInterpreterLocation(){
		try{
			Plugin plugin = Platform.getPlugin("org.rubypeople.rdt.launching");
			Class klass = plugin.getClass().getClassLoader().loadClass("org.rubypeople.rdt.internal.launching.RubyRuntime");
			Method method = klass.getDeclaredMethod("getDefault", new Class[0]);
			Object rubyRuntime = method.invoke(klass, new Object[0]);
			Method getSelectedInterpreterMethod = rubyRuntime.getClass().getDeclaredMethod("getSelectedInterpreter", new Class[0]);
			Object rubyInterpreter = getSelectedInterpreterMethod.invoke(rubyRuntime, new Object[0]);
			Method getLocationMethod = rubyInterpreter.getClass().getDeclaredMethod("getCommand", new Class[0]);
			return (String)getLocationMethod.invoke(rubyInterpreter, new Object[0]);
		}catch(Exception e){
		}
		return null;
	}

}
