/*
 * $Id: WebResourceSelectionBlock.java,v 1.1 2004/04/11 08:23:42 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

import com.narucy.webpub.core.*;

/**
 * WebResourceSelectionBlock role is provides resource selection control.
 */
public class WebResourceSelectionBlock {

	final WebResourceLinkModel model;
	final IContainer publishFolder;
	
	Label labe;
	Button toAbsolute;
	Text hrefText;

	public WebResourceSelectionBlock(IResource res) throws CoreException{
		this(res.getParent());
	}
	
	public WebResourceSelectionBlock(IContainer container) throws CoreException{
		model = new WebResourceLinkModel(container);
		publishFolder = ((WebProject)container.getProject().getNature(WebProject.ID_NATURE)).getFolder(WebProject.KEY_PUBLISH_FOLDER);
	}

	public Control createControl(Composite parent){
		final Composite base = new Composite(parent, SWT.NONE);
		
		// creates widgets
		GridLayout gl = new GridLayout(3, false);
		gl.marginHeight = 0;
		gl.marginWidth = 0;
		base.setLayout(gl);
		
		labe = new Label(base, SWT.NONE);
		labe.setText("&URL:");
		GridData gd = new GridData();
		labe.setLayoutData(gd);
		
		hrefText = new Text(base, SWT.SINGLE | SWT.BORDER);
		hrefText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		hrefText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				model.setPath(hrefText.getText());
			}
		});
		
		Button browse = new Button(base, SWT.PUSH);
		browse.setText("B&rowse...");
		
		browse.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				callResourceSelectionDialog();
			}
			public void widgetDefaultSelected(SelectionEvent e) {
			}
		});
		
		new Label(base, SWT.NONE);
		
		toAbsolute = new Button(base, SWT.CHECK);
		toAbsolute.setText("&Convert link target to absolute in web project");
		toAbsolute.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				model.setAbsolute(toAbsolute.getSelection());
			}

			public void widgetDefaultSelected(SelectionEvent e) {}
		});
		new Label(base, SWT.NONE);
		
		model.addListener(new WebResourceSelectionListener() {
			public void resourceChanged(IPath path, IResource existResource) {
				if(!path.toString().equals(hrefText.getText())){
					hrefText.setText(path.toString());
				}
				boolean absEnabled = model.getWebResource() != null;
				toAbsolute.setEnabled(absEnabled);
				toAbsolute.setSelection(absEnabled && model.isAbsolute());
			}
			public void statusChanged(IStatus status) {}
		});
		
		return base;
	}
	
	void callResourceSelectionDialog(){
		// user selection link target resource
		ResourceSelectionDialog dialog = new ResourceSelectionDialog(
			labe.getShell(),
			publishFolder,
			null);
		
		// TODO: expand folder, shows Image preview
		IResource currentSelectionResource = model.getWebResource();
		
		// in case root element is IProject has bug 48258.
		if(currentSelectionResource != null && !(publishFolder instanceof IProject)){
			dialog.setInitialSelections(new Object[]{ currentSelectionResource });
		}
		if(dialog.open() == Window.OK){
			model.setWebResource((IResource) dialog.getResult()[0]);
		}
	}

	public void setColumnNameWidth(int colNameWidth){
		((GridData)labe.getLayoutData()).widthHint = colNameWidth;
	}
	
	public void forceFocus(){
		hrefText.forceFocus();
	}

	public WebResourceLinkModel getModel() {
		return model;
	}

}
