/*
 * $Id: MnemonicNamer.java,v 1.2 2004/04/24 05:04:46 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui;

import java.util.HashMap;

/**
 * MnemonicNamer provides pull down menu label.
 */
public abstract class MnemonicNamer {

	char[] mnemonics = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
	boolean[] usedMnemonic = new boolean[mnemonics.length];
	HashMap nameMap = new HashMap();

	public abstract String toLabel(Object obj);

	public void release(Object labelObj){
		String label = (String)nameMap.remove(labelObj);
		if(label != null){
			release(label);
		}
	}

	void release(String label){
		char m = label.charAt(1);
		for(int i=0; i<usedMnemonic.length; i++){
			if(m == mnemonics[i]){
				usedMnemonic[i] = false;
			}
		}
	}

	public char getDefinedMnemonic(Object obj){
		String label = (String)nameMap.get(obj);
		return (label != null) ? label.charAt(1) : 0;
	}

	final public String getLabel(Object obj){
		String label = (String)nameMap.get(obj);
		if(label == null){
			label = toLabel(obj);
			for(int i=0; i<usedMnemonic.length; i++){
				if( !usedMnemonic[i]){
					usedMnemonic[i] = true;
					label = "&" + mnemonics[i] + " " + label;
					break;
				}
			}
			nameMap.put(obj, label);
		}
		return label;
	}

}
