/*
 * $Id: TableElementCellModifierTest.java,v 1.2 2004/04/14 02:58:56 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests.editors.html.wizards;

import java.util.Arrays;

import junit.framework.TestCase;

import org.w3c.dom.*;

import com.narucy.webpub.ui.editors.html.wizards.*;

/**
 * 
 */
public class TableElementCellModifierTest extends TestCase {

	public TableElementCellModifierTest(String arg0) {
		super(arg0);
	}

	public void testModify() throws Exception {
		TableElementCellModifier modifier = new TableElementCellModifier(null);
		
		TableElementModel model = new TableElementModel( "a b c d\ne f g h\ni j k l", true);
		assertTrue(Arrays.equals(new String[]{"A", "B", "C", "D"}, model.getColumnProperties()));
		
		Element[] rows = model.getRows();
		assertTrue( modifier.canModify(rows[0], "A") );
		assertTrue( modifier.canModify(rows[0], "D") );
		assertFalse( modifier.canModify(rows[0], "E") );
		assertFalse( modifier.canModify(rows[0], "..") );
		
		assertEquals("a", modifier.getValue(rows[0],"A") );
		assertEquals("d", modifier.getValue(rows[0],"D") );
		assertEquals("i", modifier.getValue(rows[2],"A") );
		assertEquals("l", modifier.getValue(rows[2],"D") );
		assertNull(modifier.getValue(rows[1], "E"));
		
		modifier.modify(rows[0], "A", "foo");
		Element[] cells = TableElementModel.chooseCellElements(rows[0]);
		NodeList nodes = cells[0].getChildNodes();
		assertEquals(1, nodes.getLength());
		assertEquals( "foo", nodes.item(0).getNodeValue() );
	}

}
