/*
 * $Id: StringDivideTest.java,v 1.2 2004/04/14 02:58:56 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests.editors.html.wizards;

import java.util.Arrays;

import junit.framework.TestCase;

import com.narucy.webpub.ui.editors.html.wizards.StringDivider;

/**
 * 
 */
public class StringDivideTest extends TestCase {

	public StringDivideTest(String name) {
		super(name);
	}

	public void testDivide(){
		StringDivider divider = new StringDivider();
		
		String[][] cells = divider.divide("a b c d e\nf g h\ni", "\\s+");
		assertTrue(Arrays.equals(new String[]{"a", "b", "c", "d", "e"},cells[0]));
		assertTrue(Arrays.equals(new String[]{"f", "g", "h", "",  ""},cells[1]));
		assertTrue(Arrays.equals(new String[]{"i", "", "", "",  ""},cells[2]));
		
		cells = divider.divide("a\nb\tc\td\ne\tf\tg\th\ti", "\\s+");
		assertTrue(Arrays.equals(new String[]{"a", "", "", "", ""},cells[0]));
		assertTrue(Arrays.equals(new String[]{"b", "c", "d", "",  ""},cells[1]));
		assertTrue(Arrays.equals(new String[]{"e", "f", "g", "h",  "i"},cells[2]));
		
		String s = "1\t2\t3\n4 4\t5\t6\n7\t8\t9 9 9 9";
		assertEquals("\\t", divider.getDivideSuitedRegexp(s));
		
		cells = divider.divide(s);
		assertTrue(Arrays.equals(new String[]{"1", "2", "3"},cells[0]));
		assertTrue(Arrays.equals(new String[]{"4 4", "5", "6"},cells[1]));
		assertTrue(Arrays.equals(new String[]{"7", "8", "9 9 9 9"},cells[2]));
		
		s = "1 1 1 1 1,2,3\n4,5\t5,6\n7,8,9";
		assertEquals(",", divider.getDivideSuitedRegexp(s));
		
		cells = divider.divide(s);
		assertTrue(Arrays.equals(new String[]{"1 1 1 1 1", "2", "3"},cells[0]));
		assertTrue(Arrays.equals(new String[]{"4", "5\t5", "6"},cells[1]));
		assertTrue(Arrays.equals(new String[]{"7", "8", "9"},cells[2]));
		
		s = "A or X,B,,C\nD,,E,F";
		cells = divider.divide(s);
		assertTrue(Arrays.equals(new String[]{"A or X", "B", "", "C"}, cells[0]));
		assertTrue(Arrays.equals(new String[]{"D", "", "E", "F"}, cells[1]));
	}
	
}
