/*
 * $Id: UITestUtils.java,v 1.1 2004/04/24 05:04:37 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.tests;

import java.util.ArrayList;

import org.eclipse.jface.preference.*;
import org.eclipse.jface.window.*;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;
import org.eclipse.ui.actions.ActionFactory;

/**
 * 
 */
public class UITestUtils {

	private UITestUtils() {}
	
	public static void openPreferenceDialog(){
		IWorkbench workbench = PlatformUI.getWorkbench();
		final Display disp = workbench.getDisplay();
		final ActionFactory.IWorkbenchAction act = ActionFactory.PREFERENCES.create(workbench.getActiveWorkbenchWindow());
		new Thread(){
			public void run(){
				disp.asyncExec(new Runnable() {
					public void run() {
						act.run();
					}
				});
			}
		}.start();
		while(disp.readAndDispatch());
	}
	
	static void p(Object o) {
		System.out.println(UITestUtils.class + ":" + o);
	}

	public static IPreferencePage findPreferencePage(Class klass){
		return findPreferencePage(Display.getDefault(), klass);
	}
	
	public static IPreferencePage findPreferencePage(Display disp, Class klass){
		PreferenceDialog dialog = getPreferenceDialog(disp);
		if(dialog != null){
			Object[] list = dialog.getPreferenceManager().getElements(PreferenceManager.POST_ORDER).toArray();
			for (int i = 0; i < list.length; i++) {
				IPreferencePage page = ((IPreferenceNode) list[i]).getPage();
				if(page.getClass().equals(klass)){
					return page;
				}
			}
		}
		return null;
	}
	
	public static IWizardContainer getWizardContainers(Display disp){
		Shell[] shells = disp.getShells();
		for (int i = 0; i < shells.length; i++) {
			Object data = shells[i].getData();
			if (data instanceof IWizardContainer) {
				return (IWizardContainer)data;
			}
		}
		return null;
	}
	
	public static PreferenceDialog getPreferenceDialog(Display disp){
		Window[] windows = getAllWindows(disp);
		for (int i = 0; i < windows.length; i++) {
			Window w = windows[i];
			if(w instanceof PreferenceDialog){
				return (PreferenceDialog)w;
			}
		}
		return null;
	}
	
	public static Window[] getAllWindows() {
		return getAllWindows( Display.getDefault() );
	}
	
	public static Window[] getAllWindows(Display disp) {
		ArrayList windows = new ArrayList();
		Shell[] shells = disp.getShells();
		for (int i = 0; i < shells.length; i++) {
			Shell shell = shells[i];
			Object data = shell.getData();
			if (data instanceof Window) {
				collectWindows((Window)data, windows);
			}
		}
		return (Window[]) windows.toArray(new Window[windows.size()]);
	}
	
	static void collectWindows(Window window, ArrayList dist){
		if(!dist.contains(window)){
			dist.add(window);
			WindowManager mgr = window.getWindowManager();
			if(mgr != null){
				Window[] ws = mgr.getWindows();
				for (int i = 0; i < ws.length; i++) {
					collectWindows( ws[i], dist);
				}
			}
		}
	}

	public static void displayShell(Shell shell){
		if(shell.getLayout() == null){
			shell.setLayout(new FillLayout());
		}
		if(!shell.isVisible()){
			shell.open();
		}
		Display display = shell.getDisplay();
		while(!shell.isDisposed()){
			if (!display.readAndDispatch()){
				display.sleep();
			}
		}
	}
	
	public static void displayActiveWorkbenchWindow(){
		displayShell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
	}

	public static void whileReadAndDispatch(){
		while(Display.getDefault().readAndDispatch());
	}

	public static Control findControl(Control control, Object data, Class klass){
		if(	(data == null || data.equals(control.getData())) &&
			(klass == null || klass.equals(control.getClass()) )  ){
			return control;
		}
		if(control instanceof Composite){
			Control[] cs = ((Composite)control).getChildren();
			for(int i=0; i<cs.length; i++){
				Control c =  findControl(cs[i], data, klass);
				if(c != null){
					return c;
				}
			}
		}
		return null;
	}

	public static Control findControl(Control control, Class klass){
		return findControl(control, null, klass);
	}

	public static Control findControl(Control control, Object data){
		return findControl(control, data, null);
	}

}
