/*
 * $Id: TemplateParseException.java,v 1.2 2004/04/24 05:04:51 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.template;

import org.eclipse.core.runtime.IPath;

/**
 * 
 */
public class TemplateParseException extends Exception {

	int lineNum;
	IPath errorFilePath = null;
	
	public TemplateParseException(String msg, int lineNum){
		super(msg);
		this.lineNum = lineNum;
	}

	public int getLineNum() {
		return lineNum;
	}
	public IPath getErrorFilePath() {
		return errorFilePath;
	}

	public void setErrorFilePath(IPath path) {
		errorFilePath = path;
	}

	public String getMessage() {
		String extMsg = (errorFilePath != null) ?
			"[errorFilePath=" + errorFilePath.toString() + "]" : "";
		return super.getMessage() + extMsg;
	}

	public boolean equals(Object other) {
		if(other instanceof TemplateParseException){
			TemplateParseException otherEx = (TemplateParseException)other;
			return
				lineNum == otherEx.getLineNum() &&
				getMessage().equals(otherEx.getMessage()) &&
				errorFilePath == otherEx.getErrorFilePath() ?
					true :
					errorFilePath != null && errorFilePath.equals(otherEx.getErrorFilePath());
		}else{
			return false;
		}
	}

}
