/*
 * $Id: PublisherRegistory.java,v 1.3 2004/04/01 05:48:08 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.publish;

import java.io.File;
import java.util.*;

import org.eclipse.core.runtime.*;

import com.narucy.webpub.core.WebpubPlugin;

/**
 * <p>
 * PublisherRegistory provides feature of manage publisher plug-ins.
 * This instance keeps publisher datas.
 */
public class PublisherRegistory {

	static PublisherRegistory instance = null;

	public static PublisherRegistory getInstance(){
		if( instance == null){
			instance = new PublisherRegistory();
		}
		return instance;
	}

	Map publishOrders = null;

	private PublisherRegistory() {
		try{
			publishOrders = initPublisherExtensions();
		}catch(CoreException e){
			throw new RuntimeException(e);
		}
	}
		
	/**
	 * Create publish orders that Map instance each keys are
	 * publish-by-key names values are String array that index 0 is
	 * publish script full path, index 1 is class name.
	 */
	Map initPublisherExtensions() throws CoreException{
		Map orders = new HashMap();
		
		// Load publish extension points.
		IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint("com.narucy.webpub.core.publishers");
		IExtension[] exts = extPoint.getExtensions();
		for (int i = 0; i < exts.length; i++) {
			IExtension ext = exts[i];
			Plugin plugin = ext.getDeclaringPluginDescriptor().getPlugin();
			IConfigurationElement[] elems = ext.getConfigurationElements();
			for (int j = 0; j < elems.length; j++) {
				IConfigurationElement elem = elems[j];
				if( elem.getName().equals("publisher") ){
					String id = elem.getAttribute("id");
					String scriptFile = WebpubPlugin.getLocalPath(elem.getAttribute("script"), plugin);

					if(scriptFile == null || !new File(scriptFile).exists()){
						throw new CoreException(new Status(
							IStatus.OK,
							plugin.getDescriptor().getUniqueIdentifier(),
							IStatus.ERROR,
							"Invalid publisher extension entry: " + scriptFile + " is not found.",
							null));
					}
					
					String klass = elem.getAttribute("class");
					String description = elem.getAttribute("description");
					
					orders.put(id, new String[]{ scriptFile, klass, description} );
				}
			}
		}
		
		return orders;
	}

	/**
	 * Returns publish key names.
	 */
	public String[] getPublishByKeys(){
		return (String[])publishOrders.keySet().toArray(new String[publishOrders.size()]);
	}
	
	/**
	 * Returns publisher script file location (full path for local)
	 * for specify publish key name.
	 */
	public String getPublishScriptFileLocation(String by){
		Object publisher = publishOrders.get(by);
		return (publisher != null) ? ((String[])publisher)[0] : null;
	}
	
	/**
	 * Returns publisher class name for specify publish key name.
	 */
	public String getPublishClassName(String by){
		Object publisher = publishOrders.get(by);
		return (publisher != null) ? ((String[])publisher)[1] : null;
	}
	
	/**
	 * Returns publisher description. if not specify description.
	 * return null.
	 */
	public  String getPublishDescription(String by){
		Object publisher = publishOrders.get(by);
		return (publisher != null) ? ((String[])publisher)[2] : null;
	}
	

}
