/*
 * Created on 2004/03/31
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package com.narucy.webpub.core.publish;

import java.util.HashMap;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.CoreException;

import com.narucy.webpub.core.WebpubPlugin;

public class PublishDescriptionDefinitionStore {
	
	static PublishDescriptionDefinitionStore instance = null;
	
	static PublishDescriptionDefinitionStore getInstance(){
		if(instance == null){
			instance = new PublishDescriptionDefinitionStore();
		}
		return instance;
	}

	HashMap definitionsCache = new HashMap();
	
	private PublishDescriptionDefinitionStore(){
		ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener() {
			IResourceDeltaVisitor visitor = new IResourceDeltaVisitor() {
				public boolean visit(IResourceDelta delta) throws CoreException {
					if(delta.getKind() == IResourceDelta.CHANGED || delta.getKind() == IResourceDelta.REMOVED){
						definitionsCache.remove(delta.getResource());
					}
					return true;
				}
			};
			
			public void resourceChanged(IResourceChangeEvent event) {
				if(event.getDelta() != null){
					try {
						event.getDelta().accept(visitor);
					} catch (CoreException e) {
						WebpubPlugin.handleException(e);
					}
				}
			}
		});
	}
	
	public PublishDescriptionDefinition getDescriptionDefinication(IFile propFile) {
		PublishDescriptionDefinition definition = null;
		if(definitionsCache.containsKey(propFile))
			definition = (PublishDescriptionDefinition)definitionsCache.get(propFile);
		else{
			try {
				definition = new PublishDescriptionDefinition(propFile);
			} catch (IllegalConfigurationException e) {
			}
			definitionsCache.put(propFile, definition);
		}
		return definition;
	}
}