/*
 * $Id: PresetManager.java,v 1.5 2004/04/25 00:42:31 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.preset;

import java.net.URL;
import java.util.ArrayList;

import org.eclipse.core.runtime.*;

import com.narucy.webpub.core.WebpubPlugin;

/**
 * PresetManager provides to load extension point
 * "com.narucy.webpub.core.presets".
 */
public class PresetManager {
	
	final public static String
		ID_PRESETS_EXTENSION = WebpubPlugin.ID_PLUGIN + ".presets";

	public static PresetManager instance = null;
	
	public static PresetManager getInstance() {
		if(instance == null){
			instance = new PresetManager();
		}
		return instance;
	}
	
	ArrayList presets = new ArrayList();

	private PresetManager(){
		// collect preset extensions
		IExtensionPoint extensionPoint = Platform.getPluginRegistry().getExtensionPoint(ID_PRESETS_EXTENSION);
		IExtension[] extensions = extensionPoint.getExtensions();
		
		for (int i = 0; i < extensions.length; i++) {
			IExtension ext = extensions[i];
			IConfigurationElement[] elems = ext.getConfigurationElements();
			for (int j = 0; j < elems.length; j++) {
				IConfigurationElement elem = elems[j];
				if( elem.getName().equals("preset") ){
					try {
						addPreset( createPreset(elem) );
					} catch (CoreException e) {
						WebpubPlugin.handleException(e);
					}
				}
			}
		}
	}
	
	/**
	 * Creates Preset instance as specify IConfigurationElement.
	 */
	static Preset createPreset(IConfigurationElement elem) throws CoreException {
		IPluginDescriptor pluginDesc = elem.getDeclaringExtension().getDeclaringPluginDescriptor();
		String presetRootPath = elem.getAttribute("path");
		URL presetRoot = pluginDesc.find(new Path(presetRootPath));
		if(presetRoot == null){
			throw new CoreException(new Status(
					IStatus.ERROR,
					WebpubPlugin.ID_PLUGIN,
					IStatus.OK,
					"specified resource is not exist: " + presetRootPath,
					null));
		}
		return createPreset(
				presetRoot,
				elem.getAttribute("name"),
				elem.getAttribute("description"));
		
	}
	

	public static Preset createPreset(URL baseDirectory, String name, String description) throws CoreException{
		String url = baseDirectory.toString();
		String ext = url.substring(url.length()-4);
		if( ext.equals(".zip") || ext.equals(".jar")){
			return new ZippedPreset(baseDirectory, name, description);
		} else {
			return new FilePreset(baseDirectory, name, description);
		}
	}
	
	public void addPreset(Preset preset){
		presets.add(preset);
	}
	
	public String[] getPresetNames() {
		Preset[] presets = getPresets();
		String[] names = new String[presets.length];
		for (int i=0; i<presets.length; i++) {
			names[i] = presets[i].getName();
		}
		return names;
	}

	public Preset[] getPresets() {
		return (Preset[])presets.toArray(new Preset[presets.size()]);
	}
}
