/*
 * $Id: Preset.java,v 1.5 2004/04/25 02:27:34 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.preset;

import java.io.*;
import java.net.URL;
import java.util.ArrayList;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;

import com.narucy.webpub.core.WebProject;


public abstract class Preset {

	final static String[] webProjectReflectPropKeys = {
		WebProject.KEY_HT_EXTENSIONS,
		WebProject.KEY_ENCODING,
		WebProject.KEY_TOC_PATHES,
		WebProject.KEY_DIRECTORY_INDEX,
		WebProject.KEY_IGNORE_FILE,
	};

	Preferences webProjectProp;
	
	URL baseDirectory;
	String name, description;
	
	public Preset(URL baseDirectory, String name, String description) {
		this.baseDirectory = baseDirectory;
		this.name = name;
		this.description = description;
	}
	
	public URL getBaseDirectory() {
		return baseDirectory;
	}

	public String getDescription() {
		return description;
	}
	
	public String getName() {
		return name;
	}
	
	final public WebProject distribute(final IProject proj, final String htSourcesFolder, final String scriptsFolder, final String publishFolder, IProgressMonitor monitor) throws CoreException {
		final WebProject[] webProj = {null};
		proj.getWorkspace().run(new IWorkspaceRunnable() {
			public void run(IProgressMonitor moni) throws CoreException {
				webProj[0] = internalDistribute(proj, htSourcesFolder, scriptsFolder, publishFolder, moni);
			}
		}, monitor);
		return webProj[0];
	}
	
	WebProject internalDistribute(IProject proj, String htSourcesFolder, String scriptsFolder, String publishFolder, IProgressMonitor monitor) throws CoreException {
		monitor.beginTask("create new project", 4);
		try{
			WebProject wp = WebProject.distributeNewProject(
					proj,
					htSourcesFolder,
					scriptsFolder,
					publishFolder,
					new SubProgressMonitor(monitor, 1));
			
			distribute(wp, new SubProgressMonitor(monitor, 1));
			
			for (int i = 0; i < webProjectReflectPropKeys.length; i++) {
				String k = webProjectReflectPropKeys[i];
				String v = webProjectProp.getString(k);
				if(v.length() > 0){
					wp.setValue(k, v);
				}
			}
			wp.storePreferences();
			
			proj.refreshLocal(
					IResource.DEPTH_INFINITE,
					new SubProgressMonitor(monitor, 1));
			
			proj.build(
					IncrementalProjectBuilder.INCREMENTAL_BUILD,
					new SubProgressMonitor(monitor, 1));
			
			return wp;
		}finally{
			monitor.done();
		}
	}
	
	protected void loadProperty(InputStream stream) throws IOException{
		webProjectProp = new Preferences();
		webProjectProp.load(stream);
	}
	
	public Preferences getWebProjectProperty(){
		return webProjectProp;
	}
	
	protected abstract void distribute(WebProject webProject, IProgressMonitor monitor) throws CoreException;

	protected static void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException{
		monitor.beginTask("create folder", 1000);
		try{
			ArrayList folders = new ArrayList();
			for(IContainer c = folder; !c.exists(); c = c.getParent()){
				folders.add(c);
			}
			if(folders.size() > 0){
				int ratio = 1000 / folders.size();
				for(int j=folders.size()-1; j>=0; j--){
					((IFolder)folders.get(j)).create(false, true, new SubProgressMonitor(monitor, ratio));
				}
			}
		}finally{
			monitor.done();
		}
	}
	
}
