/*
 * $Id: InterpreterCheckerManager.java,v 1.4 2004/04/24 05:04:51 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core;

import java.io.*;
import java.util.*;

import org.eclipse.core.runtime.CoreException;

/**
 * InterpreterCheckerManager.
 */
public class InterpreterCheckerManager {

	final static int ERROR = 3;
	
	String toolCommandPath;
	HashMap checkerEntries = new HashMap();

	public InterpreterCheckerManager() {
		toolCommandPath = WebpubPlugin.getLocalPath("scripts/bin/wpchecktool");
		
		String[] entries = {
			"interpreter", "scripts/lib/webpub/install_checker_items.rb", "Webpub::InterpreterChecker","Web Publisher requires Ruby that is foundation technorogies for document publish version is and need to version 1.8 or higher. http://www.ruby-lang.org",
			"amrita", "scripts/lib/webpub/install_checker_items.rb", "Webpub::AmritaChecker","Amrita is a a html/xhtml template library for Ruby. http://raa.ruby-lang.org/list.rhtml?name=amrita",
			"rd", "scripts/lib/webpub/install_checker_items.rb", "Webpub::RDChecker","RD is document RDtool is RD formater and utilities.. http://raa.ruby-lang.org/list.rhtml?name=rdtool",
		};
		
		for(int i=0; i<entries.length; i+=4){
			checkerEntries.put(
				entries[i],
					new String[]{
						WebpubPlugin.getLocalPath(entries[i+1]),
						entries[i+2],
						entries[i+3]});
		}
	}

	public String[] getGlobalEntryKeys(){
		String[] keys = (String[])checkerEntries.keySet().toArray(new String[checkerEntries.size()]);
		Arrays.sort(keys);
		return keys;
	}

	public InterpreterCheckResult check(String interpreter) throws CoreException {
		return check(interpreter, getGlobalEntryKeys());
	}
	
	public String getDescription(String key){
		if( checkerEntries.containsKey(key) ){
			return ((String[])checkerEntries.get(key))[2];
		}else{
			return null;
		}
	}

	String createArguments(String[] keys, File resultDistFile){
		StringBuffer buff = new StringBuffer(toolCommandPath + " -d" + resultDistFile);
		for (int i = 0; i < keys.length; i++) {
			String k = keys[i];
			if( checkerEntries.containsKey(k) ){
				String[] entry = (String[])checkerEntries.get(k);
				buff.append(' ' + k + ' ' + entry[0] + ' ' + entry[1]);
			}else{
				throw new IllegalArgumentException("not found key entry: " + k);
			}
		}
		return buff.toString();
	}

	public InterpreterCheckResult fastCheck(String interpreter){
		if( !new File(interpreter).isFile() ){
			InterpreterCheckResult res = new InterpreterCheckResult();
			res.put("interpreter", "Interpreter not found",  ERROR);
			return res;
		}
		return null;
	}
	
	public InterpreterCheckResult check(String interpreter, String[] keys) throws CoreException {
		InterpreterCheckResult errResult = fastCheck(interpreter);
		if(errResult != null){
			return errResult;
		}
		
		File resultDistFile = new File(
			System.getProperty("java.io.tmpdir"),
			String.valueOf(System.currentTimeMillis()) +  "InterpreterEnviornmentChecker.result");
		
		String args = createArguments(keys, resultDistFile);
		
		String errorMessage;
		try{
			Process process = WebpubPlugin.rubyExec(interpreter, args, null);
			readAllStream(process.getErrorStream(), System.err);
			readAllStream(process.getInputStream(), System.out);
			
			int exitValue = process.waitFor();
			if(exitValue == 0){
				return createResult(resultDistFile);
			}
			errorMessage = "exit value: " + exitValue;
		} catch(InterruptedException e){
			WebpubPlugin.handleException(e);
			errorMessage = e.getMessage();
		} catch (IOException e) {
			errorMessage = e.getMessage();
		}
		
		errResult = new InterpreterCheckResult();
		errResult.put("interpreter", "interpreter console error: " + errorMessage +  "(command line:" + args + ")", ERROR);
		return errResult;
	}
	
	static void readAllStream(final InputStream stream, final PrintStream printStream){
		new Thread(){
			public void run(){
				String lines = new TextReader(stream).joinedLines().trim();
				if(lines.length() > 0){
					printStream.println(lines);
				}
			}
		}.start();
	}

	InterpreterCheckResult createResult(File resultDistFile) throws IOException {
		TextReader reader = new TextReader(new FileInputStream(resultDistFile));
		InterpreterCheckResult result = new InterpreterCheckResult();
		while(reader.hasNext()){
			String[] entries = reader.nextLine().split(",");
			result.put(entries[0], entries[1], Integer.parseInt(entries[2]));
		}
		return result;
	}
	
}
