#
# $Id: webproject.rb,v 1.1 2004/01/17 12:02:26 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'webpub/eclipse_workspace'

module Webpub

class WebProject

	attr_reader :project_path

	def initialize(proj_path)
		@project_path = File.expand_path(proj_path)
		raise ArgumentError, "specify path is not directory: #{proj_path}" unless File.directory?(@project_path)
		config_file =  @project_path + '/.webproject'
		
		raise ArgumentError, "not found a project configription file: #{config_file}" unless File.file?(config_file)
		
		@entries = {}
		IO.foreach(config_file) { |line|
			@entries[$1.strip] = $2.strip if /^(.+?)=(.+)/ === line
		}
		
		%w!htsources_folder scripts_folder publish_folder!.each { |key|
			raise ArgumentError, "#{config_file} is not included entry :#{key}" unless @entries[key]
			@entries[key.gsub(/folder$/, 'dir')] = to_abs_path(@entries[key])
		}
		@entries.keys.each { |k|
			@entries[k.intern] = @entries.delete(k)
		}
		
		@name = nil
	end

	def [](key)
		@entries[key]
	end
	
	def name
		ws = EclipseWorkspace.instance
		ws.project_pathes.each { |name, path|
			return name if path.casecmp(@project_path) == 0
		}
		raise "workspace doesn't regist this web project"
	end
	
	private

	def to_abs_path(path)
		if %r!^/! === path
			segments = path.split('/').select { |v| !v.empty? }
			proj_path = EclipseWorkspace.instance.project_pathes[segments.shift]
			segments.unshift(proj_path).join('/')
		else
			File.join(@project_path, path)
		end
	end

end

end
