#
# $Id: rd_publisher.rb,v 1.1 2004/03/24 18:03:23 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'cgi'
require 'rd/rd2html-lib'
require 'rd/rdfmt'
require 'webpub/publisher'

module Webpub

class RDPublisher < Publisher

	def rd_to_html(src)
		visitor = $Visitor_Class.new
		tree = RD::RDTree.new(src, [], nil)
		tree.parse
		visitor.visit(tree)
	end

	def publish(desc)
		begin
			lines = rd_to_html(IO.read(desc.publish_from) )
			open(desc.publish_to, 'w') { |fh|
				fh << lines
			}
		rescue Exception
			open(desc.publish_to, 'w') { |fh|
				fh << "<body><h4>#{CGI.escapeHTML($!.message)}</h4>"
				fh << %Q!<pre>#{CGI.escapeHTML($!.backtrace.join("\n"))}</pre>!
				fh << '</body>'
			}
			raise $!.class, $!.message, $!.backtrace
		end
	end
end

end
