#
# $Id: copy_publisher.rb,v 1.1 2004/03/24 18:03:23 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'fileutils'
require 'webpub/publisher'

module Webpub

class CopyPublisher < Publisher

	def publish(desc)
		from = desc.publish_from
		to = desc.publish_to
		
		FileUtils.mkdir_p( File.dirname(to) )
		if File.file?(from)
			if desc.ht_filter?(desc)
				ht_distribute(desc, IO.read(from))
			else
				FileUtils.cp(from, to)
			end
		elsif File.directory?(from) and !File.exist?(to)
			Dir.mkdir(to)
		end
	end
	
end

end
