#
# $Id: abstorel_filter.rb,v 1.1 2004/01/17 12:02:27 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'webpub/publisher'

module Webpub

class AbsToRelFilter < HTFilter

	def filter(desc, lines)
		lines.gsub(%r!(\s.+?=["'])(/.+?)(["'])!) {
			rel_link = AbsToRelFilter::to_rel(
				desc.publish_to,
				desc.web_project[:publish_dir] + $2)
			$1 + rel_link + $3
		}
	end

	def AbsToRelFilter::to_rel(base, target)
		sep = /\/+/o
		base = base.split(sep)
		base.pop
		target = target.split(sep)
		while base.first == target.first
			base.shift
			target.shift
		end
		File.join([".."]*base.size+target)
	end

end

end
