#
# $Id: webproject_test.rb,v 1.1 2004/01/17 12:02:27 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'test/unit'
require 'webpub/publisher'

class WebProjectTest < Test::Unit::TestCase

	include Webpub

	def setup
		ws = EclipseWorkspace.instance
		ws.workspace_path = File.dirname(__FILE__) + '/test_workspace'
	end
	
	def test_name
		proj = WebProject.new(File.dirname(__FILE__) + '/test_workspace/web_project')
		assert_equal("web_project", proj.name)
	end
	
	def test_create_web_project
		proj = WebProject.new(File.dirname(__FILE__) + '/test_workspace/web_project')
		assert %r!web_project/ht_sources$! === proj[:htsources_dir]
		assert %r!web_project/scripts$! === proj[:scripts_dir]
		assert %r!web_project/public_html$! === proj[:publish_dir]
	end

	def test_create_web_project_as_over_project
		proj = WebProject.new( File.dirname(__FILE__) + '/test_workspace/aaa')
		assert %r!test_workspace/aaa/ht_sources$! === proj[:htsources_dir]
		assert %r!test_workspace/ccc$! === proj[:scripts_dir]
		assert %r!test_workspace/bbb$! === proj[:publish_dir]
	end
	
end
