#
# $Id: eclipse_workspace_test.rb,v 1.1 2004/01/17 12:02:26 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'test/unit'
require 'fileutils'
require 'tempfile'
require 'webpub/eclipse_workspace'

class EclipseWorkspaceTest < Test::Unit::TestCase
	
	def setup
		@workspace = Webpub::EclipseWorkspace.instance
		@workspace.workspace_path=(File.dirname(__FILE__) + '/test_workspace')
	end
	
	def test_virtual
		begin
			ws_path = Dir::tmpdir + '/workspace'
			FileUtils.cp_r(File.dirname(__FILE__) + '/test_workspace', ws_path)
			@workspace.workspace_path = ws_path
			
			assert !@workspace.virtual?
			
			FileUtils.rm_r(ws_path + '/.metadata')
			
			assert @workspace.virtual?
			
			assert_equal(
				ws_path + '/aaa',
				@workspace.project_pathes['aaa'])
			
			assert_equal(
				ws_path + '/bbb',
				@workspace.project_pathes['bbb'])
		ensure
			FileUtils.rm_r(ws_path)
		end
	end
	
	def test_choose_project_name
		f = @workspace.workspace_path + '/aaa/.project'
		name = Webpub::EclipseWorkspace::choose_project_name(f)
		assert_equal('aaa', name)
		
		f = @workspace.workspace_path + '/ccc/.project'
		name = Webpub::EclipseWorkspace::choose_project_name(f)
		assert_equal('ccc', name)
	end
	
	def test_choose_project_path
		f = @workspace.workspace_path + '/.metadata/.plugins/org.eclipse.core.resources/.projects/xyzzy/.location'
		path = @workspace.choose_project_path(f)
		assert_equal('C:/j2sdk1.4.2/demo/applets', path)
	end
	
	def test_project_path
		assert_equal(
			@workspace.workspace_path + '/aaa',
			@workspace.project_pathes['aaa'])
		
		assert_equal(
			@workspace.workspace_path + '/bbb',
			@workspace.project_pathes['bbb'])
		
		assert_equal(
			@workspace.workspace_path + '/ccc',
			@workspace.project_pathes['ccc'])
		
		assert_nil( @workspace.project_pathes['abc'])
		assert_equal(
			'C:/j2sdk1.4.2/demo/applets',
			@workspace.project_pathes['xyzzy'])
	end

	def test_project_names
		assert_equal(
			%W!aaa bbb ccc web_project xyzzy!,
			@workspace.project_names.sort)
	end
	
	##
	# web_project method provides lazy instantaion of Webpub::WebProject object.
	# 
	def test_web_project
		assert_nil( @workspace.web_project('ccc') )
		
		wp = @workspace.web_project('web_project')
		assert %r!web_project/ht_sources! === wp[:htsources_dir]
		assert %r!web_project/public_html! === wp[:publish_dir]
		assert %r!web_project/scripts! === wp[:scripts_dir]
		
		assert_nil( @workspace.web_project('xyzzy'))
	end
	
	
end
