#
# $Id: abstorel_filter_test.rb,v 1.1 2004/01/17 12:02:25 hn Exp $
# Copyright Narushima Hironori. All rights reserved.
#

require 'tmpdir'
require 'test/unit'
require 'webpub/abstorel_filter'

##
# AbsToRelFilter#filter role is transrate any tag attribute absolute path to
# relative path.
#
class AbsToRelFilterTest < Test::Unit::TestCase

	include Webpub

	def setup
		@lines = <<-EOH
		<a href="/a.html">A</a>
		<link
			href="/b/c/d.jpg" />
		<img
			src="/b/c/e/f/g.cgi"/><a href="/h/i/j.erb">J</a>
		EOH
		
		@web_project = Webpub::WebProject.new( File.dirname(__FILE__) + '/test_workspace/web_project')
		@desc = PublishDescription.new('copy', @web_project)
	end

	##
	#  A relative start path is a public_html root directory.
	#
	def test_filter_1
		@desc.publish_to = @web_project[:publish_dir] + '/foo.html'
		ls = AbsToRelFilter.new.filter(@desc, @lines)
		assert %r!href="a.html"! === ls
		assert %r!href="b/c/d.jpg"! === ls
		assert %r!src="b/c/e/f/g.cgi"! === ls
		assert %r!href="h/i/j.erb"! === ls
	end

	##
	# A relative start path is middle segument.
	#
	def test_filter_2
		@desc.publish_to = @web_project[:publish_dir] + '/b/c/foo.html'
		ls = AbsToRelFilter.new.filter(@desc, @lines)
		
		assert %r!href="../../a.html"! === ls
		assert %r!href="d.jpg"! === ls
		assert %r!src="e/f/g.cgi"! === ls
		assert %r!href="../../h/i/j.erb"! === ls
	end

	##
	# A relative start path is lower.
	#
	def test_filter_3
		@desc.publish_to = @web_project[:publish_dir] + '/b/c/e/f/foo.html'
		ls = AbsToRelFilter.new.filter(@desc, @lines)
		
		assert %r!href="../../../../a.html"! === ls
		assert %r!href="../../d.jpg"! === ls
		assert %r!src="g.cgi"! === ls
		assert %r!href="../../../../h/i/j.erb"! === ls
	end

end
