/*
 * $Id: TocFactoryTest.java,v 1.3 2004/04/01 05:48:16 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.toc;

import java.net.URL;

import junit.framework.TestCase;

import org.eclipse.core.runtime.Path;

import com.narucy.webpub.core.tests.WebpubTestPlugin;
import com.narucy.webpub.core.toc.*;

/**
 * 
 */
public class TocFactoryTest extends TestCase {

	public TocFactoryTest(String arg0) {
		super(arg0);
	}

	public void testCreateToc() throws Exception{
		URL url = WebpubTestPlugin.getDefault().find(new Path("test_projects/SitemapTest/toc.xml"));
		Toc toc = TocFactory.createToc(url.openStream());
		
		assertEquals("SITEMAP TEST", toc.getLabel());
		assertEquals(1, toc.getSubtopicCount());

		Topic[] topics = toc.getSubtopics()[0].getSubtopics();
		assertEquals(3, topics.length);
	}
	
}
