/*
 * $Id: TemplateParserTest.java,v 1.4 2004/04/24 05:04:40 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.template;

import java.util.Arrays;

import junit.framework.TestCase;

import com.narucy.webpub.core.template.*;

public class TemplateParserTest extends TestCase {

	static TemplateParser parser = new TemplateParser();

	public TemplateParserTest(String name) {
		super(name);
	}
	
	public void testParseException() throws Exception {
		TemplateParseException ex = null;
		try{
			parser.parse(
				getClass().getResource("TemplateParser-error").openStream(),
				"UTF-8");
		}catch(TemplateParseException e){
			ex = e;
		}
		assertEquals("illegal enclose, begin template name is 'B' but was 'A'", ex.getMessage());
		
		ex = null;
		try{
			parser.parse(
				getClass().getResource("TemplateParser-error2").openStream(),
				"UTF-8");
		}catch(TemplateParseException e){
			ex = e;
		}
		assertEquals("illegal enclose, not beginning template 'A'", ex.getMessage());

		ex = null;
		try{
			parser.parse(
				getClass().getResource("TemplateParser-error3").openStream(),
				"UTF-8");
		}catch(TemplateParseException e){
			ex = e;
		}
		assertEquals("illegal enclose, not beginning template 'A'", ex.getMessage());

		ex = null;
		try{
			parser.parse(
				getClass().getResource("TemplateParser-error4").openStream(),
				"UTF-8");
		}catch(TemplateParseException e){
			ex = e;
		}
		assertEquals("illegal enclose, not closed 'A'", ex.getMessage());

		ex = null;
		try{
			parser.parse(
				getClass().getResource("TemplateParser-error5").openStream(),
				"UTF-8");
		}catch(TemplateParseException e){
			ex = e;
		}
		assertEquals("illegal enclose, not closed 'E,D,C,B,A'", ex.getMessage());

		ex = null;
		try{
			parser.parse(
				getClass().getResource("TemplateParser-error6").openStream(),
				"UTF-8");
		}catch(TemplateParseException e){
			ex = e;
		}
		
}

	public void testParse() throws Exception {
		Template rootTmpl = parser.parse(
				getClass().getResource("TemplateParserTest-test").openStream(),
				"UTF-8");
		
		assertEquals(0, rootTmpl.getInvalidTemplateNames().length);
		
		Template[] tmpls = rootTmpl.getChildrenTemplates("A")[0].getChildrenTemplates();
		assertEquals(0, tmpls.length);
		
		tmpls = rootTmpl.getChildrenTemplates("B")[0].getChildrenTemplates();
		assertEquals(1, tmpls.length);
		assertEquals("A", tmpls[0].getName());
		
		tmpls = rootTmpl.getChildrenTemplates("C")[0].getChildrenTemplates();
		assertEquals(4, tmpls.length);
		assertEquals("A", tmpls[0].getName());
		assertEquals("CONTENTS", tmpls[1].getName());
		assertEquals("B", tmpls[2].getName());
		assertEquals("CONTENTS", tmpls[3].getName());
		
		tmpls = rootTmpl.getChildrenTemplates("D")[0].getChildrenTemplates();
		assertEquals(1, tmpls.length);
		assertEquals("C", tmpls[0].getName());

		tmpls = rootTmpl.getChildrenTemplates("E")[0].getChildrenTemplates();
		assertEquals(8, tmpls.length);
		assertEquals("E-A", tmpls[0].getName());
		assertEquals("CONTENTS", tmpls[1].getName());
		assertEquals("E-A", tmpls[2].getName());
		assertEquals("C", tmpls[3].getName());
		assertEquals("E-B", tmpls[4].getName());
		assertEquals("CONTENTS", tmpls[5].getName());
		assertEquals("E-B", tmpls[6].getName());
		assertEquals("CONTENTS", tmpls[7].getName());
	}
	
	public void testParseInvalidTemplate() throws Exception {
		Template rootTmpl = parser.parse(
				getClass().getResource("TemplateParserTest-invalid_test").openStream(),
				"UTF-8");
		
		String[] names = rootTmpl.getInvalidTemplateNames();
		assertTrue(Arrays.equals(names, new String[]{"A", "B", "C"}));
		
		Template[] tsA = rootTmpl.getInvalidTemplates(names[0]);
		assertEquals(4, tsA.length);
		Template[] tsB = rootTmpl.getInvalidTemplates(names[1]);
		assertEquals(2, tsB.length);
		Template[] tsC = rootTmpl.getInvalidTemplates(names[2]);
		assertEquals(2, tsC.length);
	}

	void p(Object o) {
		System.out.println(getClass() + ":" + o);
	}

}
