/*
 * $Id: PublishPropertyWriterTest.java,v 1.3 2004/04/01 05:48:15 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.publish;

import java.io.File;
import java.net.URL;

import javax.xml.parsers.DocumentBuilderFactory;

import junit.framework.TestCase;

import org.eclipse.core.runtime.Path;
import org.w3c.dom.*;

import com.narucy.webpub.core.publish.PublishPropertyWriter;
import com.narucy.webpub.core.tests.WebpubTestPlugin;

/**
 * 
 */
public class PublishPropertyWriterTest extends TestCase {

	DocumentBuilderFactory docBuilderFac = DocumentBuilderFactory.newInstance();

	public PublishPropertyWriterTest(String name) {
		super(name);
	}

	public void testStore() throws Exception {
		String[] propFiles = {
			"ht_sources/folder/.publish",
			"ht_sources/folder/subfolder/.publish",
			"ht_sources/folder/subfolder/subsubfolder/.publish",
			"ht_sources/imgs/.publish",
			"rd/.publish",
			"rd/with_tmpl/.publish",
		};
		
		File tmpFile = WebpubTestPlugin.createTempFile("PublishPropertyStoreTest.testStore");
		try{
			for (int i = 0; i < propFiles.length; i++) {
				URL url = WebpubTestPlugin.getDefault().getDescriptor().find(
					new Path("test_scripts/webpub/test_workspace/web_project/" + propFiles[i]));
				
				Document doc = docBuilderFac.newDocumentBuilder().parse(url.openStream());
				PublishPropertyWriter.store(tmpFile, doc);
				
				Document doc2 = docBuilderFac.newDocumentBuilder().parse(tmpFile);
				NodeList list = doc.getDocumentElement().getElementsByTagName("mapping");
				NodeList list2 = doc2.getDocumentElement().getElementsByTagName("mapping");
				for(int j=0; j<list.getLength(); j++){
					list.item(j).equals(list2.item(j));
				}
			}
		}finally{
			// tmpFile.delete();
		}
	}

}
