/*
 * $Id: PublishDescriptionDefinitionTest.java,v 1.4 2004/04/01 05:48:16 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.publish;

import junit.framework.TestCase;

import org.eclipse.core.resources.*;

import com.narucy.webpub.core.Wildcard;
import com.narucy.webpub.core.publish.PublishDescriptionDefinition;
import com.narucy.webpub.core.tests.WebpubTestPlugin;

/**
 *
 */
public class PublishDescriptionDefinitionTest extends TestCase {

	IProject project;
	
	protected void setUp() throws Exception {
		project = WebpubTestPlugin.createTestProject("test_scripts/webpub/test_workspace/web_project").getProject();
	}

	public void testMatchIndex() throws Exception {
		PublishDescriptionDefinition definition =
			new PublishDescriptionDefinition(project.getFile("ht_sources/folder/.publish"));
		assertEquals(4, definition.getEntryCount());
		
		assertEquals(-1, definition.getMatchIndex(project.getFile("ht_sources/null")));
		assertEquals(-1, definition.getMatchIndex(project.getFile("ht_sources/null.html")));
		assertEquals(-1, definition.getMatchIndex(project.getFile("ht_sources/folder/subfolder/subsubfolder/a.png")));

		assertEquals(0, definition.getMatchIndex(project.getFile("ht_sources/folder/subfolder/subsubfolder/s-1.html")));
		assertEquals(1, definition.getMatchIndex(project.getFile("ht_sources/folder/subfolder/subsubfolder/t-1.html")));
		assertEquals(2, definition.getMatchIndex(project.getFile("ht_sources/folder/subfolder/subsubfolder/u-1.html")));
		assertEquals(3, definition.getMatchIndex(project.getFile("ht_sources/folder/subfolder/subsubfolder/1-1-1-1.html")));
		assertEquals(3, definition.getMatchIndex(project.getFile("ht_sources/folder/subfolder/null.html")));
	}
	
	public void testPublishDescriptionDefinition() throws Exception {
		// create from erb/.publish
		IFile propFile = project.getFile("erbs/.publish");
		PublishDescriptionDefinition desc = new PublishDescriptionDefinition(propFile);
		assertEquals(2, desc.getEntryCount());
		
		assertEquals("erb", desc.getPublishBy(0));
		assertEquals(new Wildcard("c/*/*.erb"), desc.getPattern(0));
		assertEquals("erbs/*.html", desc.getArguments(0).get("publish_to"));
		
		assertEquals("erb", desc.getPublishBy(1));
		assertEquals(new Wildcard("*.erb"), desc.getPattern(1));
		assertEquals("erbs/*.html", desc.getArguments(1).get("publish_to"));
		
		// create from ht_sources/folder/.publish
		propFile = project.getFile("ht_sources/folder/.publish");
		desc = new PublishDescriptionDefinition(propFile);
		assertEquals(4, desc.getEntryCount());
		assertEquals(new Wildcard("*/*/s*.html"), desc.getPattern(0));
		assertEquals("amrita", desc.getPublishBy(0));
		assertEquals("s.rb", desc.getArguments(0).get("script"));
		assertEquals("s", desc.getArguments(0).get("method"));
		assertEquals(null, desc.getArguments(0).get("class"));
		
		assertEquals("amrita", desc.getPublishBy(1));
		assertEquals(new Wildcard("*/*/t*.html"), desc.getPattern(1));
		assertEquals("foo_folder/", desc.getArguments(1).get("publish_to"));
		assertEquals("t.rb", desc.getArguments(1).get("script"));
		assertEquals(null, desc.getArguments(1).get("method"));
		assertEquals("T", desc.getArguments(1).get("class"));
		assertEquals("x y z", desc.getArguments(1).get("opt"));
		
		assertEquals("amrita", desc.getPublishBy(2));
		assertEquals(new Wildcard("*/*/u-1.html"), desc.getPattern(2));
		assertEquals("uuu.html", desc.getArguments(2).get("publish_to"));
		assertEquals("u.rb", desc.getArguments(2).get("script"));
		assertEquals("u", desc.getArguments(2).get("method"));
		assertEquals("U", desc.getArguments(2).get("class"));
		
		assertEquals("amrita", desc.getPublishBy(3));
		assertEquals(new Wildcard("**/*.html"), desc.getPattern(3));
		assertEquals("base.rb", desc.getArguments(3).get("script"));
		assertEquals(null, desc.getArguments(3).get("method"));
		assertEquals("Base", desc.getArguments(3).get("class"));
		assertEquals(null, desc.getArguments(3).get("publish_to"));
	}
	
	protected void tearDown() throws Exception {
		WebpubTestPlugin.forceDelete(project);
	}
}
