/*
 * $Id: PresetManagerTest.java,v 1.5 2004/04/25 02:27:36 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.presets;

import java.io.IOException;
import java.util.regex.Pattern;

import junit.framework.TestCase;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.Preferences;

import com.narucy.webpub.core.*;
import com.narucy.webpub.core.preset.*;
import com.narucy.webpub.core.tests.WebpubTestPlugin;

public class PresetManagerTest extends TestCase {
	
	PresetManager manager = PresetManager.getInstance();

	public PresetManagerTest(String name){
		super(name);
	}
	
	public void _testGetPreset() throws IOException{
		Preset[] presets = manager.getPresets();
		assertEquals(4, presets.length);
		
		assertEquals("Empty", presets[0].getName());
		assertTrue(Pattern.matches(".+/empty.zip$", presets[0].getBaseDirectory().toString()));
		assertEquals(
				"Simple preset distributes only one html.",
				presets[0].getDescription());
		
		assertEquals("Company", presets[1].getName());
		assertTrue(Pattern.matches(".+/company.zip$", presets[1].getBaseDirectory().toString()));
		assertEquals(
				"Company preset distributes ordinary company web site. It preparate sitemap with relate navigation, web contents update news management rss feed.",
				presets[1].getDescription());

		Preferences prop = presets[0].getWebProjectProperty();
		assertEquals("ht_sources", prop.getString(WebProject.KEY_HTSOURCES_FOLDER));
	}

	public void testCompanyPreset() throws Exception{
		IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject("a");
		TextReader reader = null;
		try{
			Preset[] presets = manager.getPresets();
			WebProject wp = presets[1].distribute(proj, "x", "scripts", "z", null);
			
			IMarker[] markers = proj.findMarkers(null, false, IResource.DEPTH_INFINITE);
			for (int i = 0; i < markers.length; i++) {
				p( markers[i].getAttribute(IMarker.MESSAGE));
			}
			assertEquals(0, markers.length);
			assertTrue( proj.getFile("x/home.html").exists());
			assertTrue( proj.getFile("z/home.html").exists());
		}finally{
			if(reader != null){
				reader.close();
			}
			WebpubTestPlugin.forceDelete(proj);
		}
	}

	void p(Object o) {
		System.out.println(getClass() + ":" + o);
	}
	
}
