/*
 * $Id: FilePresetTest.java,v 1.1 2004/04/25 00:42:27 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests.presets;

import java.io.File;
import java.util.*;

import junit.framework.TestCase;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.Path;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.preset.FilePreset;
import com.narucy.webpub.core.tests.WebpubTestPlugin;

/**
 *
 */
public class FilePresetTest extends TestCase {

	public FilePresetTest(String name) {
		super(name);
	}
	
	IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
	IProject project = null;
	
	public void testDistribute() throws Exception{
		project = root.getProject("webProject");
		FilePreset preset = new FilePreset(
				WebpubTestPlugin.getDefault().find(new Path("test_scripts/webpub/test_workspace/web_project")),
				"name",
				"description");
		
		WebProject wp = preset.distribute(project, "xxx", "yyy", "zzz", null);
		
		assertTrue(project.getFile("xxx/home.html").exists());
		assertTrue(project.getFile("xxx/home.png").exists());
		assertTrue(project.getFile("zzz/home.html").exists());
		assertTrue(project.getFile("zzz/home.png").exists());
	}
	
	public void testGetDistributeFiles() throws Exception{
		project = root.getProject("webProject");
		FilePreset preset = new FilePreset(
				WebpubTestPlugin.getDefault().find(new Path("test_scripts/webpub/test_workspace/web_project")),
				"name",
				"description");
		
		assertEquals("name", preset.getName());
		assertEquals("description", preset.getDescription());
		
		WebProject wp = WebProject.distributeNewProject(project, "xxx", "yyy", "zzz", null);
	}
	
	public void testPresetTestProject() throws Exception {
		project = root.getProject("webProject");
		
		FilePreset preset = new FilePreset(
				WebpubTestPlugin.getDefault().find(new Path("test_projects/PresetTestProject")),
				"name",
				"description");
		
		WebProject wp = preset.distribute(project, "xxx", "yyy", "zzz", null);
		
		assertTrue(project.getFile("a/a_x").exists());
		assertTrue(project.getFile("a/aa/aa_x").exists());
		assertTrue(project.getFile("a/aa/aa_y").exists());
		assertTrue(project.getFolder("a/ab").exists());
		assertFalse(project.getFolder("a/ab/CVS").exists());
		
		assertTrue(project.getFile("b/b_x").exists());
	}
	
	protected void tearDown() throws Exception {
		if(project != null){
			WebpubTestPlugin.forceDelete(project);
			project = null;
		}
	}
}
