/*
 * $Id: WebpubPluginTest.java,v 1.7 2004/04/14 02:58:59 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.core.tests;

import java.io.File;

import junit.framework.TestCase;

import com.narucy.webpub.core.*;

public class WebpubPluginTest extends TestCase {

	public WebpubPluginTest(String arg0) {
		super(arg0);
	}
	
	public void testRubyScirpt() throws Exception {
		String testScriptPath = WebpubTestPlugin.getLocalPath("test_scripts/testall.rb");
		assertTrue(new File(testScriptPath).isFile());
		
		final Process proc = WebpubPlugin.getDefault().rubyExec(testScriptPath, null);
		final String[] outputs = new String[2];
		Thread stdoutReader = new Thread(){
			public void run(){
				TextReader r = new TextReader(proc.getInputStream());
				try{
					outputs[0] = r.joinedLines();
				}finally{
					r.close();
				}
			}
		};
		Thread stderrReader = new Thread(){
			public void run(){
				TextReader r = new TextReader(proc.getErrorStream());
				try{
					outputs[1] = r.joinedLines();
				}finally{
					r.close();
				}
			}
		};
		stdoutReader.start();
		stderrReader.start();
		while(stdoutReader.isAlive() && stderrReader.isAlive()){
			Thread.sleep(100);
		}
		assertTrue(outputs[0], outputs[0].indexOf("0 failures, 0 errors") != -1);
	}
	
	void p(Object o) {
		System.out.println(getClass() + ":" + o);
	}
	
	public void testFindInterpreter() {
		assertNotNull(WebpubPlugin.findInitialInterpreter());
		assertTrue(WebpubPlugin.findInitialInterpreter().toFile().exists());
	}
	
}
