/*
 * $Id: WebProjectStructureWizardPage.java,v 1.1 2004/01/17 12:08:07 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.wizards;


import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;

import com.narucy.webpub.core.StatusChangeListener;
import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.properties.WebProjectStructureBlock;


/**
 * 
 */
class WebProjectStructureWizardPage extends WizardPage {

	final public static String
		PAGE_NAME = "NewWebProjectWizardPage";

	StatusChangeListener statusListener = new StatusChangeListener() {
		public void statusChanged(IStatus status) {
			switch (status.getSeverity()) {
				case IStatus.ERROR:
					setErrorMessage(status.getMessage());
					setMessage(null);
					break;
				case IStatus.WARNING:
					setMessage(status.getMessage(), WARNING);
					setErrorMessage(null);
					break;
				case IStatus.OK:
					setErrorMessage(null);
					setMessage(null);
					setPageComplete(true);
					break;
			}
		}
	};

	WebProjectStructureBlock block = new WebProjectStructureBlock(statusListener);

	public WebProjectStructureWizardPage() {
		super(PAGE_NAME);
		setTitle("Web Project Folders");
		setDescription("Enter the web project auther infomation.");
		setImageDescriptor(WebpubUIPlugin.getDefault().getImageDescriptor("wizban/newwebproj_wiz.gif"));
	}

	public void createControl(Composite parent) {
		try {
			setControl( block.createControl(parent, null) );
			block.setFolderData("ht_sources", "scripts", "public_html");
			block.getButton(WebProject.KEY_HTSOURCES_FOLDER).setEnabled(false);
			block.getButton(WebProject.KEY_SCRIPTS_FOLDER).setEnabled(false);
			block.getButton(WebProject.KEY_PUBLISH_FOLDER).setEnabled(true);
		} catch (CoreException e) {
			WebpubUIPlugin.handleException(e);
		}
	}

	public WebProjectStructureBlock getBlock(){
		return block;
	}

	protected void handleException(Exception e) {
		e.printStackTrace();
		throw new RuntimeException(e);
	}

	void p(Object o) {
		System.out.println(getClass() + ":" + o);
	}

}
