/*
 * $Id: StringDivider.java,v 1.1 2004/01/17 12:08:08 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.wizards;

import java.util.Arrays;
import java.util.regex.Pattern;

class IntList {
	int[] ints;
	int size;

	public IntList(int capacity) {
		ints = new int[capacity];
		size = 0;
	}

	void add(int i) {
		ints[size] = i;
		size++;
	}
	
	int[] toArray(){
		int[] vals = new int[size];
		System.arraycopy(ints, 0, vals, 0, size);
		return vals;
	}
}

/**
 * 
 */
class StringDivider {

	static Pattern tagNameChoosePattern = Pattern.compile("<[\\s/]*(\\w+)\\s*.*>");

	static String[] splitRegexpCandidates = {
		"\\t", ",", " ", "\\s+"
	};
	
	private StringDivider() {}

	static public String[][] divide(String content){
		return divide(content, getDivideSuitedRegexp(content));
	}
	
	static public String[][] divide(String content, String regexp){
		String[] lines = content.split("\n");
		int len = lines.length;
		String[][] dist = new String[len][];
		
		int max = Integer.MIN_VALUE;
		for (int i = 0; i < len; i++) {
			String line = lines[i];
			String[] cells = line.split(regexp);
			dist[i] = cells;
			if(max < cells.length){
				max = cells.length;
			}
		}
		for (int i = 0; i < len; i++) {
			String[] newArray = new String[max];
			Arrays.fill(newArray, "");
			System.arraycopy(dist[i], 0, newArray, 0, dist[i].length);
			dist[i] = newArray;
		}
		return dist;
	}
	
	static String getDivideSuitedRegexp(String content){
		String[] lines = content.split("\n");
		
		String resultRegexp = null;
		int score = Integer.MAX_VALUE, cellCount = Integer.MIN_VALUE;
		
		for (int i = 0; i < splitRegexpCandidates.length; i++) {
			String regexp = splitRegexpCandidates[i];
			int max = Integer.MIN_VALUE, min = Integer.MAX_VALUE;
			for (int j = 0; j < lines.length; j++) {
				String[] vals = lines[j].split(regexp);
				if(max < vals.length){
					max = vals.length;
				}
				if(min > vals.length){
					min = vals.length;
				}
			}
			int s = max - min;
			if( score > s || (score == s && max > cellCount)){
				cellCount = max;
				score = s;
				resultRegexp = regexp;
			}
		}
		
		return resultRegexp;
	}

}
