/*
 * $Id: NewWebProjectWizard.java,v 1.1 2004/01/17 12:08:06 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.wizards;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.*;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.properties.WebProjectStructureBlock;

/**
 * NewWebProjectWizard 
 */
public class NewWebProjectWizard extends BasicNewResourceWizard {

	IWorkbench workbench;
	
	WizardNewProjectCreationPage newProjectPage;
	WebProjectStructureWizardPage structurePage;
	PresetSelectionWizardPage presetPage;
	
	public NewWebProjectWizard() {
		setWindowTitle("New Web Project");
		setNeedsProgressMonitor(true);
	}
	
	static WizardNewProjectCreationPage createNewProjectCreationPage(){
		WizardNewProjectCreationPage page = new WizardNewProjectCreationPage("WizardNewProjectCreationPage");
		page.setDescription("Enter the required data to generate website source files");
		page.setTitle("Web Project");
		page.setImageDescriptor(WebpubUIPlugin.getDefault().getImageDescriptor("wizban/newwebproj_wiz.gif"));
		return page;
	}

	public void addPages() {
		addPage(newProjectPage = createNewProjectCreationPage());
		addPage(structurePage = new WebProjectStructureWizardPage());
		addPage(presetPage = new PresetSelectionWizardPage());
	}

	public boolean canFinish() {
		if( super.canFinish() ){
			return (getContainer().getCurrentPage() == getPages()[ getPageCount()-1 ]);
		}
		return false;
	}

	IRunnableWithProgress distProcess = new IRunnableWithProgress() {
		IPerspectiveDescriptor findWebDevPerspective(){
			return WebpubUIPlugin.getDefault().getWorkbench().getPerspectiveRegistry()
				.findPerspectiveWithId("com.narucy.webpub.WebDevPerspective");
		}
		
		public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
			monitor.beginTask("Create project resources", 7);
			IProject project = newProjectPage.getProjectHandle();
			try {
				// create and store project file
				createProject(project, new SubProgressMonitor(monitor, 1) );
				
				// store datas
				WebProject webProj = (WebProject)project.getNature(WebProject.ID_NATURE);
				presetPage.storePresets(webProj, new SubProgressMonitor(monitor, 2) );
				project.refreshLocal(IResource.DEPTH_INFINITE, new SubProgressMonitor(monitor, 1));
				
				project.build( IncrementalProjectBuilder.FULL_BUILD, new SubProgressMonitor(monitor, 2));
				
				// changes perspective
				IWorkbenchPage workbenchPage = WebpubUIPlugin.getActivePage();
				workbenchPage.setPerspective(findWebDevPerspective());
				
				// expand Navigator View - project folder.
				IResourceNavigator navigatorView =
					(IResourceNavigator)workbenchPage.findView("org.eclipse.ui.views.ResourceNavigator");
				
				if( navigatorView != null){
					TreeViewer tree = navigatorView.getViewer();
					tree.expandToLevel(project, 2);
					tree.setSelection(new StructuredSelection(project));
				}
			}
			catch (CoreException e) {
				WebpubUIPlugin.handleException(e);
			}
			finally{
				monitor.done();
			}
		}
		
		void createProject(IProject project, IProgressMonitor monitor) throws CoreException{
			try{
				monitor.beginTask("Distribute Web Project Folder", IProgressMonitor.UNKNOWN);
				
				WebProjectStructureBlock block = structurePage.getBlock();
				
				// create project.
				WebProject.storeNewProject(
					project,
					block.getText(WebProject.KEY_HTSOURCES_FOLDER),
					block.getText(WebProject.KEY_SCRIPTS_FOLDER),
					block.getText(WebProject.KEY_PUBLISH_FOLDER),
					new SubProgressMonitor(monitor, 1) );
			
				// if navigator view is visibled when expand hierarchy as root web
				// project directory.
				IResourceNavigator navigatorView =
					(IResourceNavigator)WebpubUIPlugin.getActivePage().findView("org.eclipse.ui.views.ResourceNavigator");
				if( navigatorView != null){
					TreeViewer tree = navigatorView.getViewer();
					tree.expandToLevel(project, TreeViewer.ALL_LEVELS);
					tree.setSelection(new StructuredSelection(project));
				}
			}
			finally{
				monitor.done();
			}
		}

	};
	
	public boolean performFinish() {
		try {
			getContainer().run(false, true, distProcess);
			
		} catch (InvocationTargetException e) {
			WebpubUIPlugin.handleException(e);
			return false;
		} catch  (InterruptedException e) {
			WebpubUIPlugin.handleException(e);
			return false;
		}
		return true;
	}

}
