/*
 * $Id: AElementWizardPage.java,v 1.1 2004/01/17 12:08:08 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;
import org.w3c.dom.Element;

import com.narucy.webpub.ui.WebResourceSelectionAdapter;

/**
 * 
 */
public class AElementWizardPage extends EditElementWizardPage {

	Combo frameTargets;
	WebResourceSelectionBlock block;

	public AElementWizardPage() {
		super("AElementWizardPage");
		setTitle("Anchor");
		setDescription("Anchor element edit speciy link target.");
	}

	public void createChildControl(Composite parent) throws CoreException {
		parent.setLayout( new GridLayout(2, false) );
		
		// file selection block
		block = new WebResourceSelectionBlock(getEditFile());
		
		block.getModel().addListener( new WebResourceSelectionAdapter(this) {
			public void resourceChanged(IPath path, IResource existResource) {
				refreshPreview();				
			}
		});
		Control blockControl = block.createControl(parent);
		GridData gd = new GridData( GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;
		blockControl.setLayoutData(gd);
		
		// a href optional
		Label labe = new Label(parent, SWT.NONE);
		labe.setText("Target Frame:");
		block.setColumnNameWidth(labe.computeSize(SWT.DEFAULT, SWT.DEFAULT).x);
		
		frameTargets = new Combo(parent, SWT.SINGLE | SWT.BORDER);
		gd = new GridData();
		frameTargets.setLayoutData(gd);
		
		frameTargets.add("_self");
		frameTargets.add("_top");
		frameTargets.add("_blink");
		frameTargets.add("_parent");
		frameTargets.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				refreshPreview();
			}
		});
		
		parent.layout();
		block.forceFocus();
		
		// init ui values.
		String selText = ((EditElementWizard) getWizard() ).getSelection().getText();
		String content;
		switch (getEditType()) {
			case NEW:
				content = selText;
				break;
			case MODIFY:
				Element elem = getParsedSelectionText();
				if(elem != null){
					block.getModel().setPath(elem.getAttribute("href"));
				
					// select frame target item of link attributes value.
					// or not exist in frame target combo, addition the item attribute value.
					String item = elem.getAttribute("link");
					String[] items = frameTargets.getItems();
					for(int i=0; i<items.length; i++){
						if( items[i].equals(item)){
							frameTargets.select(i);
							item = null;
							break;
						}
					}
					if( item != null){
						frameTargets.add(item);
					}
				}
				
				content = chooseContent(selText);
				break;
		}
	}
	
	
	public String getPreviewText() {
		String content = ((EditElementWizard) getWizard()).getSelection().getText();
		
		String href = "";
		String frameTargetName = null;
		
		if(getEditType() == MODIFY){
			Element elem = getParsedSelectionText();
			href = elem.getAttribute("href");
			frameTargetName = elem.getAttribute("link");
			content = chooseContent(content);
		}
		if( block != null){
			// ui initialized. get form widget.
			IPath hrefPath = block.getModel().getPath();
			href = hrefPath != null ? hrefPath.toString() : "";
			
			frameTargetName = frameTargets.getText();
		}
		
		String elem = "<a href=\"" + href + "\"";
		if( frameTargetName != null && frameTargetName.length() > 0){
			elem += " target=\"" + frameTargetName + "\"";
		}
		return elem + ">" + content + "</a>";
	}
	
}