/*
 * $Id: TocView.java,v 1.1 2004/01/17 12:08:11 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.views.navigator.ResourceNavigator;

import com.narucy.webpub.core.toc.Topic;

/**
 * SitemapView
 */
public class TocView extends ResourceNavigator {

	// Persistance tags.
	final static String
		TAG_FILTERS = "filters",
		TAG_FILTER = "filter",
		TAG_SELECTION = "selection",
		TAG_EXPANDED = "expanded",
		TAG_ELEMENT = "element",
		TAG_IS_ENABLED = "isEnabled",
		TAG_PATH = "path",
		TAG_CURRENT_FRAME = "currentFrame";

	public void setFocus() {
	}

	protected void makeActions() {
		setActionGroup(new TocActionGroup(this));
		getTreeViewer().expandToLevel(2);
	}
	
	protected IStructuredSelection convertTocToFile(IStructuredSelection sel){
		Object[] selItems = sel.toArray();
		for(int i=0; i<selItems.length; i++){
			Object item = selItems[i];
			if( !(item instanceof IResource) && item instanceof IAdaptable){
				IResource res = (IResource)((IAdaptable)item).getAdapter(IResource.class);
				if(res != null){
					selItems[i] = res;
				}
			}
		}
		return new StructuredSelection(selItems);
	}

	protected IStructuredSelection convertFileToToc(IStructuredSelection selection){
		Object[] selItems = ((IStructuredSelection)selection).toArray();
		for (int i = 0; i < selItems.length; i++) {
			Object item = selItems[i];
			if(item instanceof IFile){
				Topic t = (Topic)((IFile)item).getAdapter(Topic.class);
				if(t != null){
					selItems[i] = t;
				}
			}
		}
		return new StructuredSelection(selItems);
	}
	
	protected void handleOpen(OpenEvent event) {
		IStructuredSelection sel = (IStructuredSelection) event.getSelection();
		getActionGroup().runDefaultAction( convertTocToFile(sel) );
	}

	protected void linkToEditor(IStructuredSelection selection) {
		super.linkToEditor( convertTocToFile(selection) );
	}

	protected void editorActivated(IEditorPart editor) {
		if (!isLinkingEnabled()) {
			return;
		}
		IEditorInput input = editor.getEditorInput();
		if (input instanceof IFileEditorInput) {
			IFileEditorInput fileInput = (IFileEditorInput) input;
			IFile file = fileInput.getFile();
			Topic topic = (Topic)file.getAdapter(Topic.class);
			
			if( topic != null){
				ISelection newSelection = new StructuredSelection(topic);
				if (!getTreeViewer().getSelection().equals(newSelection)) {
					getTreeViewer().setSelection(newSelection);
				}
			}
		}
	}

	protected void initContentProvider(TreeViewer viewer) {
		viewer.setContentProvider(new TocContentProvider() );
	}

	protected void fillContextMenu(IMenuManager menu) {
		IStructuredSelection sel = convertTocToFile((IStructuredSelection)getViewer().getSelection());
		
		getActionGroup().setContext(new ActionContext(sel));
		getActionGroup().fillContextMenu(menu);
	}

	public void saveState(IMemento memento) {
		// not implements yet.
	}

}
	
