/*
 * $Id: TocContentProvider.java,v 1.1 2004/01/17 12:08:11 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.views;

import java.util.HashMap;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.model.WorkbenchContentProvider;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.toc.*;
import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * Extends of workbench content provider for toc.
 */
public class TocContentProvider implements ITreeContentProvider {

	AbstractTreeViewer viewer;

	HashMap listenersCache = new HashMap();

	WorkbenchContentProvider workbenchContentProvider = new WorkbenchContentProvider();

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		workbenchContentProvider.inputChanged(viewer, oldInput, newInput);
		this.viewer = (AbstractTreeViewer)viewer;
	}

	public Object[] getChildren(Object parentElem) {
		try {
			if(parentElem instanceof IProject){
				return getProjectChildren((IProject)parentElem);
			}else if(parentElem instanceof Topic){
				return ((Topic)parentElem).getSubtopics();
			}
		} catch (CoreException e) {
			WebpubUIPlugin.handleException(e);
		}
		return null;
	}
	
	Object[] getProjectChildren(IProject proj) throws CoreException {
		final WebProject wp = (WebProject)proj.getNature(WebProject.ID_NATURE);
		if(wp == null){
			return null;
		}
		IFile[] files = wp.getTocFiles();
		Object[] children = new Object[files.length];
		for (int i = 0; i < files.length; i++) {
			IFile f = files[i];
			Toc toc = wp.getToc(f);
			children[i] = (toc != null) ? (Object)toc : (Object)f;
			
			if(toc != null && !listenersCache.containsKey(toc)){
				TocListener listener = new TocListener() {
					public void topicChanged(TocEvent[] events) {
						viewer.refresh();
					}
				};
				toc.addTocListener(listener);
				listenersCache.put(toc, listener);
			}
		}
		return children;
	}
	
	public Object getParent(Object element) {
		return workbenchContentProvider.getParent(element);
	}

	public boolean hasChildren(Object element) {
		return workbenchContentProvider.hasChildren(element);
	}

	public Object[] getElements(Object inputElement) {
		return workbenchContentProvider.getElements(inputElement);
	}

	public void dispose() {	
		Object[] tocs = listenersCache.keySet().toArray();
		for (int i = 0; i < tocs.length; i++) {
			Toc toc = (Toc)tocs[i];
			toc.removeTocListener( (TocListener)listenersCache.remove(toc));
		}
		workbenchContentProvider.dispose();
	}

}
