/*
 * $Id: TemplateManagerViewer.java,v 1.1 2004/01/17 12:08:10 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.views;

import java.util.HashMap;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

import com.narucy.webpub.core.template.*;
import com.narucy.webpub.ui.WebpubUIPlugin;


/**
 * TemplateManagerViewer.
 * @TODO: change to TableTreeViewer to JDT:Hierarchy view style.
 */
public class TemplateManagerViewer extends TableTreeViewer {
	
	final public static String
		NAME = "name",
		DEFINED_LOCATION = "definedLocation",
		DESCRIPTION = "description";
	
	final static HashMap columnNames = new HashMap(3);
	final static String[] defaultColumn = {
		NAME,
		DEFINED_LOCATION,
		DESCRIPTION 
	};

	static {
		columnNames.put(NAME, "Name");
		columnNames.put(DEFINED_LOCATION, "Defined Location");
		columnNames.put(DESCRIPTION, "Description");
	}
	
	static class TemplateManagerContentProvider implements ITreeContentProvider {

		TemplateManager manager;

		public void dispose() {
			manager = null;
		}

		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}

		public Object[] getChildren(Object parentElement) {
			if(parentElement instanceof Template){
				Template tmpl = (Template)parentElement;
				return manager.getTemplateDefinedFiles(tmpl.getName());
			}
			return null;
		}

		public Object getParent(Object element) {
			if(element instanceof IFile){
				IFile file = (IFile)element;
				return manager.getTemplatesFromCache(file);
			}
			return null;
		}

		public boolean hasChildren(Object element) {
			if( element instanceof Template){
				Template tmpl = (Template)element;
				return manager.getTemplateDefinedFiles(tmpl.getName()).length > 0;
			}
			else{
				return false;
			}
		}

		public Object[] getElements(Object inputElement) {
			if(inputElement instanceof TemplateManager){
				manager = (TemplateManager)inputElement;
				return manager.getGlobalTemplates();
			}
			else{
				return new Object[0];
			}
		}
	}

	class TemplateLabelProvider extends LabelProvider implements ITableLabelProvider {

//		HashMap expandImages = new HashMap(2);

		public Image getColumnImage(Object element, int columnIndex) {
			return null;
			/*
			// Image support
			if( columnIndex != 1){
				return null;
			}
			ImageDescriptor imgDesc = null;
			if( element instanceof Template){
				imgDesc = WebPubImages.createImageDescriptor("obj16/template.gif");
			}
			if( element instanceof IFile){
				IFile file = (IFile)element;
				String ext = file.getFileExtension();
				imgDesc = WebpubUIPlugin.getDefault().getWorkbench()
					.getEditorRegistry().getImageDescriptor(file);
			}
			Image img = (Image)expandImages.get(imgDesc);
			if( img == null){
				img = imgDesc.createImage();
				expandImages.put(imgDesc, img);
			}
			return img;
			*/
		}

		public String getColumnText(Object element, int colIndex) {
			String text = "";
			if( element instanceof Template ){
				Template tmpl = (Template)element;
				if( colIndex == 0){
					text = tmpl.getName();
				}
				if( colIndex == 2){
					text = "(Length:" + tmpl.getJoinedLines().length() + ")";
				}
			} else if( element instanceof IFile && colIndex == 1){
				IFile f = (IFile)element;
				String path = f.getFullPath().toString();
				text = path.substring( path.indexOf('/', 1) + 1);
			}
			return text;
		}
	
		public boolean isLabelProperty(Object element, String property) {
			Object[] columnProperties = getColumnProperties();
			for(int i=0; i<columnProperties.length; i++){
				if( columnProperties[i].equals(property) ){
					return true;
				}
			}
			return false;
		}

		public void dispose() {
			/*
			// dispose image
			Object[] imgs = expandImages.values().toArray();
			for (int i = 0; i < imgs.length; i++) {
				((Image)imgs[i]).dispose();
			}
			*/
		}
	
		void p(Object o) {
			System.out.println(getClass() + ":" + o);
		}

	}

	public TemplateManagerViewer(Composite parent) {
		super(parent, SWT.SINGLE | SWT.FULL_SELECTION);
		// listener
		addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				handleDoubleClick(event);
			}
		});
		
		// column properties settings.
		setContentProvider( new TemplateManagerContentProvider() );
		setLabelProvider(new TemplateLabelProvider());
		
		String[] columnProperties = (String[])defaultColumn.clone();
		setColumnProperties(columnProperties);
		
		// table settings.
		Table table = getTableTree().getTable();
		for (int i = 0; i < columnProperties.length; i++) {
			String key = columnProperties[i];
			TableColumn col = new TableColumn(table, SWT.NONE);
			col.setText( (String)columnNames.get(key) );
		}
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
		TableColumn[] columns = table.getColumns();
		for (int i = 0; i < columns.length; i++) {
			columns[i].pack();
		}
	}
	
	void handleDoubleClick(DoubleClickEvent event){
		IStructuredSelection sel = (IStructuredSelection)event.getSelection();
		Object input = sel.getFirstElement();
		if( input instanceof IFile){
			try {
				IEditorPart part =
					WebpubUIPlugin.getActivePage().openEditor( (IFile)input);
				
				if( part instanceof ITextEditor){
					ITextEditor ed = (ITextEditor)part;
					IDocument doc = ed.getDocumentProvider().getDocument(ed.getEditorInput());
					
					Template t = getCurrentSelectionTemplate();
					int matchLine = beginTmplLineNumber(doc, t.getName());
					
					ed.getSelectionProvider().setSelection(new TextSelection(doc.getLineOffset(matchLine), 0) );
				}
			} catch (PartInitException e) {
				WebpubUIPlugin.handleException(e);
			} catch (BadLocationException e) {
				WebpubUIPlugin.handleException(e);
			}
		}
		getCurrentSelectionTemplate();
	}
	
	Template getCurrentSelectionTemplate(){
		TableTree tableTree = getTableTree();
		TableTreeItem item = tableTree.getSelection()[0];
		
		Item itm = getParentItem(item);
		if( itm != null){
			Object data = itm.getData();
			if( data instanceof Template){
				return (Template)data;
			}
		}
		return null;
	}
	
	static int beginTmplLineNumber(IDocument doc, String tmplName) throws BadLocationException{
		for(int i=0, lineCount = doc.getNumberOfLines(); i<lineCount; i++){
			IRegion region = doc.getLineInformation(i);
			String line = doc.get(region.getOffset(), region.getLength());
			if( tmplName.equals(TemplateParser.matchBeginTmplateLine(line)) ){
				return i;
			}
		}
		return -1;
	}

}

