package com.narucy.webpub.ui.views;

import java.io.*;
import java.text.DateFormat;
import java.util.Date;

import org.eclipse.core.resources.*;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.part.ViewPart;

import com.narucy.webpub.core.TextReader;
import com.narucy.webpub.core.publish.PublisherBuilder;
import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * 
 */
public class PublishConsoleView extends ViewPart {

	final static String ID_DEFINICATION_FONT =
		"com.narucy.webpub.ui.PublishConsoleFont";

	String originalTitle;
	DateFormat dateFormat = DateFormat.getDateTimeInstance();

	long lastModified;
	Text console;

	IResourceChangeListener resourceListener = new IResourceChangeListener() {
		public void resourceChanged(IResourceChangeEvent event) {
			final Display disp = getSite().getShell().getDisplay();
			disp.syncExec(new Runnable() {
				public void run() {
					if( !disp.isDisposed()){
						reload(false);
					}
				}
			});
		}
	};
	
	IPropertyChangeListener fontChangeListener = new IPropertyChangeListener() {
		public void propertyChange(PropertyChangeEvent event) {
			if( event.getProperty().equals(ID_DEFINICATION_FONT) ){
				revalidateFont();
			}
		}
	};
	
	IPropertyChangeListener prefListener = new IPropertyChangeListener() {
		public void propertyChange(PropertyChangeEvent event) {
			if( event.getProperty().equals(WebpubUIPlugin.PUBLISH_CONSOLE_CHARSET)){
				reload(true);
			}
		}
	};

	public void createPartControl(Composite parent)  {
		console = new Text(parent, SWT.READ_ONLY | SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL);
		revalidateFont();
		
		IActionBars bars = getViewSite().getActionBars();
		bars.setGlobalActionHandler(IWorkbenchActionConstants.COPY, new Action() {
			public void run() {
				if( console.isFocusControl()){
					console.copy();
				}
			}
		});
		
		originalTitle = getTitle();
		reload(true);

		ResourcesPlugin.getWorkspace().addResourceChangeListener( resourceListener);
		JFaceResources.getFontRegistry().addListener(fontChangeListener);
		WebpubUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(prefListener);
	}
	
	void revalidateFont(){
		console.setFont( JFaceResources.getFontRegistry().get(ID_DEFINICATION_FONT) );
	}

	public void setFocus() {
		// nothing todo.
	}
	
	void reload(boolean forceReload){
		File tmpFile = PublisherBuilder.UNPARSED_LINES_TEMPORARY_FILE;
		String title = originalTitle;
		if( tmpFile.exists() ){
			long lm = tmpFile.lastModified();
			if ( lastModified != lm || forceReload){
				lastModified = lm;
				try {
					String charset = WebpubUIPlugin.getDefault().getPreferenceStore().getString(WebpubUIPlugin.PUBLISH_CONSOLE_CHARSET);
					console.setText( new TextReader(tmpFile.toURL(), charset).joinedLines() );
				} catch (FileNotFoundException e) {
					WebpubUIPlugin.handleException(e);
				} catch (IOException e) {
					WebpubUIPlugin.handleException(e);
				}
				String dateStr = dateFormat.format(new Date(lastModified));
				title += " [" + dateStr + "]";
			}
		}else{
			console.setText("A publish console is not an available.");
		}
		setTitle(title);
	}
	
	public void dispose() {
		ResourcesPlugin.getWorkspace().removeResourceChangeListener(resourceListener);
		WebpubUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(prefListener);
		JFaceResources.getFontRegistry().removeListener(fontChangeListener);
	}

}
