/*
 * $Id: IEWebBrowser.java,v 1.1 2004/01/17 12:08:10 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.views;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.ole.win32.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * 
 */
public class IEWebBrowser extends AbstractWebBrowser{

	URL lastBrowseUrl = null;

	OleFrame webFrame;
	OleControlSite controlSite;
	OleAutomation oleAutomation;
	
	public Control createControl(Composite composite) {
		webFrame = new OleFrame(composite, SWT.NONE);
		controlSite = new OleControlSite(webFrame, SWT.NONE, "Shell.Explorer");
		oleAutomation = new OleAutomation(controlSite);
		
		if( controlSite.doVerb(OLE.OLEIVERB_INPLACEACTIVATE) != OLE.S_OK ){
			throw new RuntimeException("can not create web browser control");
		}
		
		browsePage(null);
		
		// browse started id : 252
		controlSite.addEventListener(252, new OleListener() {
			public void handleEvent(OleEvent event) {
				String urlStr = event.arguments[1].getString();
				URL before = lastBrowseUrl;
				lastBrowseUrl = toURL(urlStr);
				firePropertyChanged(
					new PropertyChangeEvent(
						IEWebBrowser.this,
						EVENT_NAME_URL_CHANGE_STARTED,
						before,
						lastBrowseUrl));
			}
		});

		// browse started id : 259
		controlSite.addEventListener(259, new OleListener() {
			public void handleEvent(OleEvent event) {
				String urlStr = event.arguments[1].getString();
				firePropertyChanged(
					new PropertyChangeEvent(
						IEWebBrowser.this,
						EVENT_NAME_URL_CHANGE_COMPLETED,
						null,
						toURL(urlStr)) );
			}
		});
		
		return webFrame;
	}
	
	static URL toURL(String anyUrl){
		if( anyUrl.substring(0, 5).equals("about") ){
			return null;
		}
		URL url = null;
		try{
			url = new URL(anyUrl);
		}catch(MalformedURLException e){
			try {
				url = new File(anyUrl).toURL();
			} catch (MalformedURLException e1) {
			}
		}
		return url;
	}
	
	public URL getCurrentURL(){
		return lastBrowseUrl;
		/*
		OleAutomation automation = new OleAutomation(controlSite);
		int[] rgdispid = automation.getIDsOfNames(new String[]{"LocationUrl"});
		int dispIdMember = rgdispid[0];

		Variant result = automation.getProperty(dispIdMember);
		try{
			return new URL(result.getString());
		}catch(MalformedURLException e){
		}
		return null;
		*/
	}
	
	public synchronized void browsePage(URL url) {
		String[] setUrlIds = new String[] { "Navigate", "URL" };
		
		int[] rgdispid = oleAutomation.getIDsOfNames(setUrlIds);
		int dispIdMember = rgdispid[0];
		
		String arg = url != null ? url.toString() : "about:blank";
		Variant[] rgvarg = new Variant[]{
			new Variant(arg)
		};
		
		int[] rgdispidNamedArgs = new int[]{
			rgdispid[1]	// identifier of argument
		};
		oleAutomation.invoke(dispIdMember, rgvarg, rgdispidNamedArgs);
		webFrame.redraw();
	}

	public String getTitle() {
		OleAutomation automation = new OleAutomation(controlSite);
		int[] docDispId = automation.getIDsOfNames(new String[]{"Document"});
		Variant document = automation.getProperty(docDispId[0]);
		
		OleAutomation docAutomation = document.getAutomation();
		int[] titleDispId = docAutomation.getIDsOfNames(new String[]{"title"});
		Variant title = docAutomation.getProperty(titleDispId[0]);
		
		return title.getString();
	}
	
}
