/*
 * $Id: HTPreviewSelectionProvider.java,v 1.1 2004/01/17 12:08:11 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.views;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.ISelectionListener;

/**
 * 
 */
class HTPreviewSelectionProvider implements ISelectionProvider {
	
	final HTPreView preview;
	ArrayList listenerList = new ArrayList();
	ISelection selection = null;

	public HTPreviewSelectionProvider(HTPreView preview) {
		this.preview = preview;
	}

	public void addSelectionChangedListener(ISelectionChangedListener listener) {
		listenerList.add(listener);
	}

	public ISelection getSelection() {
		return selection;
	}

	public void removeSelectionChangedListener(ISelectionChangedListener listener) {
		listenerList.remove(listener);
	}

	public void setSelection(ISelection sel) {
		if(sel instanceof IStructuredSelection){
			Object o = ((IStructuredSelection)sel).getFirstElement();
			if(o instanceof URL){
				URL url = (URL)o;
				String path = new File((url).getFile()).toString();
				
				IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(new Path(path));
				if(files.length > 0){
					sel = new StructuredSelection(files);
				}
			}
		}
		if(sel != selection && sel != null ? !sel.equals(selection) : !selection.equals(sel)){
			selection = sel;
			fireSelectionChanged();
		}
	}
	
	protected void fireSelectionChanged(){
		Object[] listeners = listenerList.toArray();
		for(int i=0; i<listeners.length; i++){
			((ISelectionListener)listeners[i]).selectionChanged(preview, selection);
		}
	}

}
