/*
 * $Id: GlobalTemplateView.java,v 1.1 2004/01/17 12:08:11 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.views;

import java.util.HashMap;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.*;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.navigator.IResourceNavigator;

import com.narucy.webpub.core.template.TemplateManager;
import com.narucy.webpub.core.template.TemplateManagerListener;
import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * 
 */
public class GlobalTemplateView extends ViewPart {

	String originalTitle;
	
	IProject currentProject = null;
	TemplateManagerViewer viewer;
	
	ISelectionService selService;
	HashMap listenersRef = new HashMap();
	Action reloadAction;
	
	ISelectionListener selListener = new ISelectionListener() {
		public void selectionChanged(IWorkbenchPart part, ISelection selection) {
			workbenchSelectionChanged(selection);
		}
	};
	
	TemplateManagerListener managerListener = new TemplateManagerListener() {
		Runnable proc = new Runnable() {
			public void run() {
				packColumns();
			}
		};
		
		public void templateModified(IProject proj) {
			getSite().getShell().getDisplay().syncExec(proc);
		}
	};

	public void createPartControl(Composite parent) {
		originalTitle = getTitle();
		viewer = new TemplateManagerViewer(parent);
		
		reloadAction = new Action("Reload", WebpubUIPlugin.getDefault().getImageDescriptor("ctool16/reload.gif") ){
			public void run(){
				try {
					((TemplateManager)viewer.getInput()).researchAll(new NullProgressMonitor());
					packColumns();
				} catch (CoreException e) {
					WebpubUIPlugin.handleException(e);
				}
			}
		};
		IViewSite site = getViewSite();
		site.getActionBars().getToolBarManager().add(reloadAction);
		
		// regist selection
		selService = site.getWorkbenchWindow().getSelectionService();
		selService.addSelectionListener(selListener);
		
		// init selection,
		workbenchSelectionChanged(selService.getSelection());
		
		// If current active selection is not contain IResource,
		// Choose form navigator view.
		if(currentProject == null){
			IResourceNavigator navigatorView =
				(IResourceNavigator)site.getPage().findView("org.eclipse.ui.views.ResourceNavigator");
			if( navigatorView != null){
				 workbenchSelectionChanged( navigatorView.getViewSite().getSelectionProvider().getSelection() );
			}
		}
	}
	
	void packColumns(){
		if( currentProject != null && !viewer.getControl().isDisposed()){
			viewer.refresh();
			TableColumn[] cols = viewer.getTableTree().getTable().getColumns();
			for(int i=0; i<cols.length; i++){
				cols[i].pack();
			}
		}
	}
	
	public void workbenchSelectionChanged(ISelection selection){
		if( selection instanceof IStructuredSelection){
			Object[] items = ((IStructuredSelection)selection).toArray();
			for( int i=0; i<items.length; i++){
				IResource res = getResource(items[i]);
				if(res != null){
					try {
						changeShowProject( res.getProject() );
					} catch (CoreException e) {
						WebpubUIPlugin.handleException(e);
					}
				}
			}
		}
	}
		
	static IResource getResource(Object o){
		if(o instanceof IResource){
			return (IResource)o;
		}
		if(o instanceof IAdaptable){
			return (IResource)((IAdaptable)o).getAdapter(IResource.class);
		}
		return null;
	}
	
	void changeShowProject(IProject proj) throws CoreException{
		if(proj == currentProject){
			return;
		}
		TemplateManager mgr = (TemplateManager)viewer.getInput();
		if(mgr != null){
			mgr.removeListener(managerListener);
		}
		currentProject = proj;
		if( proj != null){
			mgr = TemplateManager.getManagerInstance(proj);
			if(mgr != null){
				mgr.addListener(managerListener);
				
				try {
					// TODO: preference setting: always check template.
					mgr.researchAll(new NullProgressMonitor());
				} catch (CoreException e) {
					WebpubUIPlugin.handleException(e);
				}
				viewer.setInput(mgr);
				viewer.refresh(true);
			}
			reloadAction.setEnabled(true);
			setTitle(originalTitle + " - " + proj.getName() );
		}
		else {
			viewer.setInput(null);
			reloadAction.setEnabled(false);
			setTitle(originalTitle);
		}
		
		packColumns();
	}

	public void setFocus() {
		// Do nothing.
	}
	
	void p(Object o) {
		System.out.println(getClass() + ":" + o);
	}

	public void dispose() {
		selService.removeSelectionListener(selListener);
		
		TemplateManager manager = (TemplateManager)viewer.getInput();
		if(currentProject != null){
			manager.removeListener(managerListener);
		}
		super.dispose();
	}

}
