/*
 * $Id: AbstractWebBrowser.java,v 1.1 2004/01/17 12:08:11 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.views;

import java.net.URL;

import org.eclipse.jface.util.*;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * 
 */
public abstract class AbstractWebBrowser {

	final public static String
		EVENT_NAME_URL_CHANGE_STARTED = "url_change_started",
		EVENT_NAME_URL_CHANGE_COMPLETED = "url_change_complted";

	ListenerList listeners = new ListenerList();

	public abstract Control createControl(Composite parent);

	public abstract void browsePage(URL url);

	public abstract URL getCurrentURL();

	public void reload(){
		URL url = getCurrentURL();
		if( url != null ){
			browsePage(url);
		}
	}
	
	public abstract String getTitle();

	public void addPropertyChangeListener(IPropertyChangeListener listener){
		listeners.add(listener);
	}

	public void removePropertyChangeListener(IPropertyChangeListener listener){
		listeners.remove(listener);
	}
	
	protected void firePropertyChanged(PropertyChangeEvent ev){
		Object[] ls = listeners.getListeners();
		for (int i = 0; i < ls.length; i++) {
			((IPropertyChangeListener) ls[i]).propertyChange(ev);
		}
	}

}
