/*
 * $Id: PublishPreferencePage.java,v 1.1 2004/01/17 12:08:09 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.preferences;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import com.narucy.webpub.ui.WebpubUIPlugin;

public class PublishPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

	class IgnoreFileListEditor extends ListEditor {
		IInputValidator validator = new IInputValidator() {
			public String isValid(String pattern) {
				if (pattern.indexOf(' ') != -1) {
					return "Invalid char";
				}
				try {
					Pattern.compile(pattern);
					return null;
				} catch (PatternSyntaxException e) {
					return "Pattern syntax is invalid";
				}

			}
		};

		public IgnoreFileListEditor(String name, String labelText, Composite parent) {
			super(name, labelText, parent);
		}

		protected String createList(String[] items) {
			return WebpubUIPlugin.join(items);
		}

		protected String getNewInputObject() {
			InputDialog dialog = new InputDialog(getShell(), null, "Input ignore file pattern", null, validator);
			dialog.open();
			return dialog.getValue();
		}

		protected String[] parseString(String line) {
			return StringConverter.asArray(line);
		}
	}

	ListEditor list;

	public PublishPreferencePage() {
		super(FieldEditorPreferencePage.GRID);
		setPreferenceStore(WebpubUIPlugin.getDefault().getPreferenceStore());
	}

	protected void createFieldEditors() {
		list = new IgnoreFileListEditor(
			WebpubUIPlugin.IGNORE_PUBLISH_FILE_PATTERNS,
			"&Ignore publish file patterns",
			getFieldEditorParent() );

		addField(list);
	}

	public void init(IWorkbench workbench) {
		// nothing to do.
	}

}