package com.narucy.webpub.ui.preferences;

import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import com.narucy.webpub.core.WebpubPlugin;
import com.narucy.webpub.ui.WebpubUIPlugin;

public class PublishConsolePreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

	public PublishConsolePreferencePage() {
		super(FieldEditorPreferencePage.GRID);
		setPreferenceStore(WebpubUIPlugin.getDefault().getPreferenceStore());
	}

	public void init(IWorkbench workbench)  {
	}

	protected void createFieldEditors() {
		String[] supportCharSets = WebpubPlugin.getSupportCharsets();
		String[][] charsets = new String[supportCharSets.length][2];
		for (int i = 0; i < supportCharSets.length; i++) {
			charsets[i][0] = supportCharSets[i];
			charsets[i][1] = supportCharSets[i];
		}
		
		addField(new RadioGroupFieldEditor(
			WebpubUIPlugin.PUBLISH_CONSOLE_CHARSET,
			"Console char set",
			1,
			charsets,
			getFieldEditorParent()) );
	}
}
