/*
 * $Id: HTPreviewPreferencePage.java,v 1.1 2004/01/17 12:08:09 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.preferences;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.*;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import com.narucy.webpub.ui.JFaceUtilities;
import com.narucy.webpub.ui.WebpubUIPlugin;

/**
 * 
 */
public class HTPreviewPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {
	
	ListEditor createExtensionListEditor(String name, String labelText, Composite parent){
		return new ListEditor( name, labelText, parent ){

			protected String createList(String[] items) {
				return WebpubUIPlugin.join(items);
			}

			protected String getNewInputObject() {
				InputDialog dialog = new InputDialog(
					getShell(),
					null,
					"Input name extension of to use amrita publish",
					null,
					JFaceUtilities.FILE_EXTENSION_VALIDATOR);
				
				dialog.open();
				return dialog.getValue();
			}

			protected String[] parseString(String stringList) {
				return StringConverter.asArray(stringList);
			}
			
		};
	}
	
	public HTPreviewPreferencePage() {
		super(FieldEditorPreferencePage.GRID);
		setPreferenceStore( WebpubUIPlugin.getDefault().getPreferenceStore() );
	}

	public void init(IWorkbench workbench) {
		// nothing to do.
	}

	protected void createFieldEditors() {
		Composite parent = getFieldEditorParent();
		
		BooleanFieldEditor editor = new BooleanFieldEditor(
			WebpubUIPlugin.HT_PREVIEW_LINK_WITH_EDITOR,
			"Preview content &link with editor",
			parent);
		addField(editor);
		
		ListEditor list = createExtensionListEditor(
			WebpubUIPlugin.HT_PREVIEW_EXTENSIONS,
			"Preview target file extensions",
			parent);
		
		addField(list);
	}

}
