/*
 * $Id: TopicPropertySheetPage.java,v 1.1 2004/01/17 12:08:08 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.toc;

import org.eclipse.jface.action.*;
import org.eclipse.ui.views.properties.*;

import com.narucy.webpub.core.toc.Topic;

/**
 * IPropertySheetPage
 */
class TopicPropertySheetPage extends PropertySheetPage {

	IAction advanced;
	TocPropertySource propSource = new TocPropertySource();;

	public TopicPropertySheetPage(){
		setPropertySourceProvider(new IPropertySourceProvider() {
			public IPropertySource getPropertySource(Object o) {
				if(o instanceof Topic){
					propSource.setTopic((Topic)o);
					return propSource;
				}
				return null;
			}
		});
	}

	public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
		advanced = new Action("Show &Advanced Properties", IAction.AS_CHECK_BOX) {
			public void run(){
			}
		};
		menuManager.add(advanced);
	}
	

}
