/*
 * $Id: TocTreeEditor.java,v 1.1 2004/01/17 12:08:08 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.toc;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;
import org.eclipse.ui.part.EditorPart;

import com.narucy.webpub.core.WebProject;

/**
 * 
 */
class TocTreeEditor extends EditorPart {

	final TocMultiPageEditor parentEditor;

	IContainer publishFolder;

	TocEditBlock block;
	Composite base;
	Label titleLabel;
	
	Color bgColor;
	Font titleFont;
	
	boolean dirty;
	
	public TocTreeEditor(TocMultiPageEditor parentEditor) {
		this.parentEditor = parentEditor;
	}

	public void doSave(IProgressMonitor monitor) {
	}

	public void doSaveAs() {
	}

	public void gotoMarker(IMarker marker) {
		// not implements
	}

	public void init(IEditorSite site, IEditorInput input) throws PartInitException {
		setSite(site);
		setInput(input);
		try {
			IProject proj = ((IFileEditorInput) input).getFile().getProject();
			WebProject wp = (WebProject) proj.getNature(WebProject.ID_NATURE);
			publishFolder = wp.getFolder(WebProject.KEY_PUBLISH_FOLDER);
		} catch (CoreException e) {
			throw new PartInitException(e.getStatus());
		}
	}

	public boolean isDirty() {
		return false;
	}

	public boolean isSaveAsAllowed() {
		return true;
	}

	public void createPartControl(Composite parent) {
		parent.setLayout(new FillLayout());
		
		// create bases
		Display disp = parent.getDisplay();
		bgColor = new Color(disp, 255, 255, 255);
		FontData data = parent.getFont().getFontData()[0];
		titleFont = new Font(disp, data.getName(), data.getHeight()*3/2, SWT.BOLD);
		
		base = new Composite(parent, SWT.NONE);
		base.setLayout(new GridLayout(1, true));
		
		parent.addDisposeListener(new DisposeListener() {
			public void widgetDisposed(DisposeEvent e) {
				bgColor.dispose();
				titleFont.dispose();
			}
		});

		// create widgets
		titleLabel = new Label(base, SWT.NONE);
		titleLabel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		titleLabel.setText("Sitemap");
		titleLabel.setFont(titleFont);
		
		block = new TocEditBlock(base);
		
		// init datas
		block.getControl().setLayoutData(new GridData(GridData.FILL_BOTH));
		
		// set background
		base.setBackground(bgColor);
		titleLabel.setBackground(bgColor);
		block.setBackground(bgColor);
		
		// set input and selection provider
		block.setInput(publishFolder, parentEditor.getToc());
		getSite().setSelectionProvider(block.getTocTree());
	}
	
	void p(Object o) {
		System.out.println(getClass() + ":" + o);
	}

	public void setFocus() {
	}

	public TocEditBlock getBlock() {
		return block;
	}

	public void dispose() {
		bgColor.dispose();
		titleFont.dispose();
		super.dispose();
	}

}
