/*
 * $Id: TagScanner.java,v 1.1 2004/01/17 12:08:02 hn Exp $
 * Copyright Narushima Hironori. All rights reserved.
 */
package com.narucy.webpub.ui.editors.html;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.*;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.editors.ColorManager;

/**
 * 
 *
 */
class TagScanner extends BufferedRuleBasedScanner implements IPropertyChangeListener {

	ColorManager manager;
	Token attrToken = null;
	Token tagToken = null;

	public TagScanner(ColorManager manager) {
		this.manager = manager;
		initToken();
		
		IRule[] rules = new IRule[3];
		// Add rule for single and double quotes
		rules[0] = new SingleLineRule("\"", "\"", attrToken, '\\');
		rules[1] = new SingleLineRule("'", "'", attrToken, '\\');
	
		// Add generic whitespace rule.
		rules[2] = new WhitespaceRule(new HTWhitespaceDetector());
		setRules(rules);

		setDefaultReturnToken(tagToken);
	}
	
	private void initToken(){
		TextAttribute attr = new TextAttribute(manager.getColor(WebpubUIPlugin.HT_EDITOR_COLOR_ATTR));
		if(attrToken == null){
			attrToken = new Token(attr);
		}else{
			attrToken.setData(attr);
		}
		
		attr = new TextAttribute(manager.getColor(WebpubUIPlugin.HT_EDITOR_COLOR_TAG));
		if(tagToken == null){
			tagToken = new Token(attr);			
		}else{
			tagToken.setData(attr);
		}
	}

	public void propertyChange(PropertyChangeEvent event) {
		String prop = event.getProperty();
		if( prop.equals(WebpubUIPlugin.HT_EDITOR_COLOR_ATTR) || prop.equals(WebpubUIPlugin.HT_EDITOR_COLOR_TAG) ){
			initToken();
		}
	}
	

}
